C
C------------------------------------------------------
C
C     Problem:    BEER
C
C     Date:       25.5.1999
C
C------------------------------------------------------
C
*     REAl CONSTANT
      initj = 70
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      V1, V2, V3, V4, V5, V6, K1, K2, K3, K4, K5
      K7, K8, K9, K10, K11, K12
      a, b, c, j, d, e, f
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION a_t
      at = (-(V1*a)/(K1 + a))*j
      a_t = at
C
*     FUNCTION b_t
      bt = (-(V2*b)/(K2 + b))*(K4/(K4 + a))*j
      b_t = bt
C
*     FUNCTION c_t
      ct = (-(V3*c)/(K3 + c))*(K4/(K4 + a))*(K5/(K5 + b))*j
      c_t = ct
C
*     FUNCTION j_t
      if (j.ne.initj) then
        jt =  -((0.134*at) + (0.268*bt) + (0.402*ct))
     /         *(K10/(K10 + ((j - initj)**K11)))
      else
        jt =  -((0.134*at) + (0.268*bt) + (0.402*ct))
      endif
      j_t =  jt
C
*     FUNCTION d_t
      Delay = 1 - exp(-t/K12)
      d_t = -V4*j_t*(d/(K7 + d))*Delay
C
*     FUNCTION e_t
      e_t = -V5*j_t*(e/(K8 + e))*Delay
C
*     FUNCTION f_t
      f_t = -V6*j_t*(f/(K9 + f))*Delay
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION a_0
      a_0 = 70
C
*     FUNCTION b_0
      b_0 = 220
C
*     FUNCTION c_0
      c_0 = 40
C
*     FUNCTION j_0
      j_0 = initj
C
*     FUNCTION d_0
      d_0 = 1.28
C
*     FUNCTION e_0
      e_0 = 0.63
C
*     FUNCTION f_0
      f_0 = 1.01
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION a_fit
      a_fit = a
C
*     FUNCTION b_fit
      b_fit = b
C
*     FUNCTION c_fit
      c_fit = c
C
*     FUNCTION j_fit
      j_fit = j
C
*     FUNCTION d_fit
      d_fit = d
C
*     FUNCTION e_fit
      e_fit = e
C
*     FUNCTION f_fit
      f_fit = f
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
