C
C------------------------------------------------------
C
C     Problem:    BEAD
C
C     Date:       13.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      R=0.1 
      X=1        
      S0=10
      S10=1
      S20=1
      S30=1
      S40=1
      S50=1
      S60=1
      deltar=R/6
      r6=deltar
      r5=2*deltar
      r4=3*deltar
      r3=4*deltar
      r2=5*deltar
      r1=R
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      Dscale, OURmax, Ks, S1, S2, S3, S4, S5, S6, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION S1P
      D=Dscale*1E-6
      RS1=-OURmax*X*S1/(Ks+S1)
      S1P=3*D*(((r1**2)*(S0-S1))-((r2**2)*(S1-S2)))
     /     /(deltar*((r1**3)-(r2**3)))+RS1
C
*     FUNCTION S2P
      RS2=-OURmax*X*S2/(Ks+S2)  
      S2P=3*D*(((r2**2)*(S1-S2))-((r3**2)*(S2-S3)))
     /     /(deltar*((r2**3)-(r3**3)))+RS2
C
*     FUNCTION S3P
      RS3=-OURmax*X*S3/(Ks+S3)
      S3P=3*D*(((r3**2)*(S2-S3))-((r4**2)*(S3-S4)))
     /     /(deltar*((r3**3)-(r4**3)))+RS3
C
*     FUNCTION S4P
      RS4=-OURmax*X*S4/(Ks+S4)
      S4P=3*D*(((r4**2)*(S3-S4))-((r5**2)*(S4-S5)))
     /     /(deltar*((r4**3)-(r5**3)))+RS4
C
*     FUNCTION S5P
      RS5=-OURmax*X*S5/(Ks+S5)
      S5P=3*D*(((r5**2)*(S4-S5))-((r6**2)*(S5-S6)))
     /     /(deltar*((r5**3)-(r6**3)))+RS5
C
*     FUNCTION S6P
      RS6=-OURmax*X*S6/(Ks+S6)
      S6P=3*D*(S5-S6)/(deltar**2)+RS6
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION S1_0
      S1_0 = S10
C
*     FUNCTION S2_0
      S2_0 = S20
C
*     FUNCTION S3_0
      S3_0 = S30
C
*     FUNCTION S4_0
      S4_0 = S40
C
*     FUNCTION S5_0
      S5_0 = S50
C
*     FUNCTION S6_0
      S6_0 = S60
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION S1_fit
      S1_fit = S1
C
*     FUNCTION S2_fit
      S2_fit = S2
C
*     FUNCTION S3_fit
      S3_fit = S3
C
*     FUNCTION S4_fit
      S4_fit = S4
C
*     FUNCTION S5_fit
      S5_fit = S5
C
*     FUNCTION S6_fit
      S6_fit = S6
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
