C
C------------------------------------------------------
C
C     Problem:    BCBPLUS
C
C     Date:       29.10.2002
C
C------------------------------------------------------
C
*     REAL CONSTANT
      k1  = 1.0E+09
      k2  = 3.16E+07
      k3  = 8.9E+09
      k4  = 1.1E+02
      k5  = 9.8E+06
      k6  = 5.0E+07
      k7  = 6.6E+02
      k8  = 5.4E+06
      k9  = 1.0E-02
      k10 = 7.0E-02
      k17 = 2.0E+03
      k18 = 2.2E+03
      k19 = 2.0E+04
      k20 = 1.3E+04
      s13 = 1.0E+0
      s14 = 1.0E+7
      s15 = 1.0E+7
      s16 = 1.0E+0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k11, k12, k13, k14, k15, k16
      y1, y2, y3, y4, y5, y6, y7, y8, y9, y10, y11, y12, y13
      c, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION dy1
      dy1  =  -k1*y1*y2 + k2*y3 - k3*y4*y5*y1 +
     /        k4*y6 - k6*y4*y2*y1 + k7*y8 - 2*k8*y8*y2*y2*y1*y1+
     /        2*k9*y7*y7*y4*y4 - k10*y3*y5*y1 -   
     /        2*k11*y1*y1*y2*y2*y4 + k11*y1*y1*y2*y2*y4 -
     /        k12*y9*y1*y2 - k13*s13*y10*y2*y1 + k13*s13*y10*y2*y1 + 
     /        k14*s14*y9*y4 + 2*k15*s15*y10*y4 + 2*k16*s16*y9*y6 + 3*k17*y10*y6+ 
     /        k19*y10*y8 + k20*y12*y4
C
*     FUNCTION dy2
      dy2  =  -k1*y1*y2 + k2*y3 - 2*k5*y6*y2*y2-  
     /        k6*y4*y2*y1 + k7*y8 - 2*k8*y8*y2*y2*y1*y1 + 
     /        2*k9*y7*y7*y4*y4 - 2*k11*y1*y1*y2*y2*y4 - 
     /        k12*y9*y1*y2 - k13*s13*y10*y2*y1
C
*     FUNCTION dy3
      dy3  =  k1*y1*y2 - k2*y3 - k10*y3*y5*y1
C
*     FUNCTION dy4
      dy4 =  -k3*y4*y5*y1 + k4*y6 - k6*y4*y2*y1 + 
     /        k7*y8 + 2*k8*y8*y2*y2*y1*y1 - 2*k9*y7*y7*y4*y4 + 
     /        2*k10*y3*y5*y1 - 1*k11*y1*y1*y2*y2*y4 + 
     /        k12*y9*y1*y2 + k13*s13*y10*y2*y1 - k14*s14*y9*y4 -
     /        k15*s15*y10*y4 + 2*k18*y9*y8 + 2*k19*y10*y8 - k20*y12*y4
C
*     FUNCTION dy5
      dy5  =  -k3*y4*y5*y1 + k4*y6 + 2*k5*y6*y2*y2 -
     /        k10*y3*y5*y1 + k11*y1*y1*y2*y2*y4 + k14*s14*y9*y4 + 
     /        k15*s15*y10*y4 + 2*k16*s16*y9*y6 + 2*k17*y10*y6 + k20*y12*y4
C
*     FUNCTION dy6
      dy6 =  k3*y4*y5*y1 - k4*y6 - k5*y6*y2*y2 - 
     /        k16*s16*y9*y6 - k17*y10*y6
C
*     FUNCTION dy7
      dy7 =  2*k5*y6*y2*y2 + 2*k8*y8*y2*y2*y1*y1 - 
     /        2*k9*y7*y7*y4*y4 + 2*k11*y1*y1*y2*y2*y4
C
*     FUNCTION dy8
      dy8 =  k6*y4*y2*y1 - k7*y8 - k8*y8*y2*y2*y1*y1 + 
     /        k9*y7*y7*y4*y4 - k18*y9*y8 - k19*y10*y8
C
*     FUNCTION dy9
      dy9 =  -k12*y9*y1*y2 - k14*s14*y9*y4 - k16*s16*y9*y6 - 
     /        k18*y9*y8
C
*     FUNCTION dy10
      dy10 =  k12*y9*y1*y2 - k13*s13*y10*y2*y1 + k14*s14*y9*y4 - 
     /        k15*s15*y10*y4 + k16*s16*y9*y6 - k17*y10*y6 + k18*y9*y8 -
     /        k19*y10*y8
C
*     FUNCTION dy11
      dy11 =  k13*s13*y10*y2*y1 + k15*s15*y10*y4 + k17*y10*y6 + 
     /        k19*y10*y8
C
*     FUNCTION dy12
      dy12 =  k13*s13*y10*y2*y1 + k15*s15*y10*y4 + k17*y10*y6 + 
     /        k19*y10*y8 - k20*y12*y4
C
*     FUNCTION dy13
      dy13 =  k20*y12*y4
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = 0.8
C
*     FUNCTION y2_0
      IF (c.lt.1.5) then
        y2_0 = 0.02
      ELSE
      IF (c.lt.2.5) then
        y2_0 = 0.03
      ELSE
      IF (c.lt.3.5) then
        y2_0 = 0.04
      ELSE
        y2_0 = 0.05
      ENDIF
      ENDIF
      ENDIF
C
*     FUNCTION y3_0
      y3_0 = 0
C
*     FUNCTION y4_0
      y4_0 = 0
C
*     FUNCTION y5_0
      y5_0 = 0
C
*     FUNCTION y6_0
      y6_0 = 0
C
*     FUNCTION y7_0
      y7_0 = 0
C
*     FUNCTION y8_0
      y8_0 = 0
C
*     FUNCTION y9_0
      y9_0 = 2E-5
C
*     FUNCTION y10_0
      y10_0 = 0
C
*     FUNCTION y11_0
      y11_0 = 0
C
*     FUNCTION y12_0
      y12_0 = 0
C
*     FUNCTION y13_0
      y13_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
*     FUNCTION y3_fit
      y3_fit = y3
C
*     FUNCTION y4_fit
      y42_fit = y4
C
*     FUNCTION y5_fit
      y5_fit = y5
C
*     FUNCTION y6_fit
      y6_fit = y6
C
*     FUNCTION y7_fit
      y7_fit = y7
C
*     FUNCTION y8_fit
      y8_fit = y8
C
*     FUNCTION y9_fit
      y9_fit = y9
C
*     FUNCTION y10_fit
      y10_fit = y10
C
*     FUNCTION y11_fit
      y11_fit = y11
C
*     FUNCTION y12_fit
      y12_fit = y12
C
*     FUNCTION y13_fit
      y13_fit = y13
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
