C
C------------------------------------------------------
C
C     Problem:    BATSEQ 
C
C     Date:       18.01.1996
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      K1, K2, K3, K4, A, B, C, D, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION AP
      AP = -K1*A   
C
*     FUNCTION BP
      BP = K1*A - K2*B + K3*C - K4*B 
C
*     FUNCTION CP
      CP = K2*B - K3*C   
C
*     FUNCTION DP
      DP = K4*B 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION A0
      A0 = 1.0
C
*     FUNCTION B0
      B0 = 0.0
C
*     FUNCTION C0
      C0 = 0.0
C
*     FUNCTION D0
      D0 = 0.0
C
C------------------------------------------------------
C
C   - Fitting criteria:
*     FUNCTION ASIM
      ASIM = A
C
*     FUNCTION BSIM
      BSIM = B
C
*     FUNCTION CSIM
      CSIM = C
C
*     FUNCTION DSIM
      DSIM = D
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

