C
C------------------------------------------------------
C
C     Problem:    BATSEQ
C
C     Date:       08.02.01
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      Da, Eta, y, x, Theta
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION yp
      I = Exp(-Theta)
      yp = -Da*(y*(y+Eta-1)-I*Eta)
C
*     FUNCTION xp
      xp = Da*((1-x)*(Eta-x)-I*Eta)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y_0
      y_0 = 1
C
*     FUNCTION x_0
      x_0 = 0 
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y_fit
      y_fit = y
C
*     FUNCTION x_fit
      x_fit = x
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
