C
C------------------------------------------------------
C
C   Problem:    BATFERM
C
C   Date:       09.09.97
C
C------------------------------------------------------
C
*     REAL CONSTANT
      KS = 0.1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      UM, K1, K2, Y, X, S, P, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION XP
      S1=S
      IF (S1.LT.0) THEN
        S1 = 0
      ENDIF
      U = UM*S1/(KS + S1)
      RX = U*X
      XP = RX 
C
*     FUNCTION SP
      RS = -RX/Y
      SP = RS
C
*     FUNCTION PP
      RP = (K1 + K2*U)*X
      PP = RP
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X0
      X0 = 0.01
C
*     FUNCTION S0
      S0 = 10
C
*     FUNCTION P0
      P0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION XFIT
      XFIT = X
C
*     FUNCTION SFIT
      SFIT = S
C
*     FUNCTION PFIT
      PFIT = P
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

