C
C------------------------------------------------------
C
C     Problem:    BATCOM
C
C     Date:       23.01.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      R=1.9869
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      A1, A2, A3, A4, B1, B2, B3, B4, A, B, C, D, TR, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION AP
      T1=R*(TR+273)   
      K1=A1*1E+12*EXP(-B1*1E5/T1)   
      K2=A2*1E+14*EXP(-B2*1E5/T1)   
      K3=A3*1E+5*EXP(-B3*1E5/T1)
      K4=A4*1E+10*EXP(-B4*1E5/T1)   
      K5=1.30000E-02   
      AP=-(K1+K2)*A   
C
*     FUNCTION BP
      BP=K1*A-K3*B
C
*     FUNCTION CP
      CP=K2*A-K4*C
C
*     FUNCTION DP
      DP=K3*B-K5*D
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION A0
      A0= 1
C
*     FUNCTION B0
      B0= 0
C
*     FUNCTION C0
      C0= 0
C
*     FUNCTION D0
      D0= 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION AFIT
      AFIT= A
C
*     FUNCTION BFIT
      BFIT= B
C
*     FUNCTION CFIT
      CFIT= C
C
*     FUNCTION DFIT
      DFIT= D
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

