C
C------------------------------------------------------
C
C     Problem:    BATCH_X2
C
C     Date:       12.02.2007
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Tb = 342.15         
      q1 = 0.00315
      q2 = 1.07
      q3 = 4.93
      q9 = 0.04
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      q4, q5, q6, q7, q8
      T, Qplus, x1i, x2i, x3i, x4i, x5i, x6i
      x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, time
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_p              
      k1 = exp(q1 - (1/T - 1/Tb)*exp(q7))
      k2 = exp(q2 - (1/T - 1/Tb)*exp(q8))
      km1 = exp(q3 - (1/T - 1/Tb)*exp(q9))
      x1_p = -k2*x2*x8
C
*     FUNCTION x2_p
      x2_p = -k1*x2*x6 + km1*x10 - k2*x2*x8
C
*     FUNCTION x3_p
      x3_p = k2*x2*x8 + k1*x4*x6 - 0.5*km1*x9
C
*     FUNCTION x4_p
      x4_p = -k1*x4*x6 + 0.5*km1*x9
C
*     FUNCTION x5_p
      x5_p = k1*x2*x6 + km1*x10 
C
*     FUNCTION x6_p
      x6_p = -k1*x2*x6 - k1*x4*x6 + km1*x10 + 0.5*km1*x9
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C                    
*     FUNCTION a1
      a1 = -x7 + x6 + x8 + x9 + x10 - Qplus
C      
*     FUNCTION a2
      kk1 = exp(-q4)
      kk2 = exp(-q5)      
      kk3 = exp(-q6)
      a2 = -x8*(kk2 + x7) + x1*kk2
C
*     FUNCTION a3
      a3 = -x9*(kk3 + x7) + x3*kk3
C
*     FUNCTION a4
      a4 = -x10*(kk1 + x7) + x5*kk1
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      x1_0 = x1i
C
*     FUNCTION x2_0
      x2_0 = x2i
C
*     FUNCTION x3_0
      x3_0 = x3i
C
*     FUNCTION x4_0
      x4_0 = x4i
C
*     FUNCTION x5_0
      x5_0 = x5i
C
*     FUNCTION x6_0
      x6_0 = x6i
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION x7_0
      x7_0 = 0
C
*     FUNCTION x8_0
      x8_0 = 0
C
*     FUNCTION x9_0
      x9_0 = 0
C
*     FUNCTION x10_0
      x10_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
*     FUNCTION x4_fit
      x4_fit = x4
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


