C
C------------------------------------------------------
C
C     Problem:    BATCH_E3
C
C     Date:       28.12.01
C
C------------------------------------------------------
C
*     REAL CONSTANT
      T   = 373
      R   = 1.9869
      Q   = 0.0131
      y01 = 1.5608
      y02 = 8.3546
      y03 = 0.0082
      y04 = 0.0086
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      alpha1, E1, alpha2, E2, alpham1, Em1, p1, p2, p3
      y1, y2, y3, y4, y5, y6, y7, time
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      k1   = exp(alpha1 - E1*10000 /(R*T))
      k2   = exp(alpha2 - E2*10000 /(R*T))
      km1  = exp(alpham1- Em1*10000/(R*T))
      KK1  = exp(p1)
      KK2  = exp(p2)
      KK3  = exp(p3)
      y8   = KK2*y1/(KK2 + y7)
      y9   = KK3*y3/(KK3 + y7)
      y10  = KK1*y5/(KK1 + y7)
      y1_t = -k2*y2*y8 
C
*     FUNCTION y2_t
      y2_t = -k1*y2*y6 + km1*y10 - k2*y2*y8
C
*     FUNCTION y3_t
      y3_t = k2*y2*y8 + k1*y4*y6 - km1*y9/2.0
C
*     FUNCTION y4_t
      y4_t = -k1*y4*y6 + km1*y9/2.0
C
*     FUNCTION y5_t
      y5_t = k1*y2*y6 - km1*y10
C
*     FUNCTION y6_t
      y6_t = -k1*y6*(y2 + y4) + km1*(y10 + y9/2.0)
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION alg_equ
      k1  = exp(alpha1 - E1*10000 /(R*T))
      k2  = exp(alpha2 - E2*10000 /(R*T))
      km1 = exp(alpham1- Em1*10000/(R*T))
      KK1 = exp(p1)
      KK2 = exp(p2)
      KK3 = exp(p3)
      y8 = KK2*y1/(KK2 + y7)
      y9 = KK3*y3/(KK3 + y7)
      y10= KK1*y5/(KK1 + y7)
      alg_equ = (-Q + y6 + y8 + y9 + y10 - y7)/Q
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = y01
C
*     FUNCTION y2_0
      y2_0 = y02
C
*     FUNCTION y3_0
      y3_0 = y03
C
*     FUNCTION y4_0
      y4_0 = y04
C
*     FUNCTION y5_0
      y5_0 = 0
C
*     FUNCTION y6_0
      y6_0 = Q
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION y7_0
      KK1 = exp(p1)
      KK2 = exp(p2)
      KK3 = exp(p3)
      y7_0 = (-KK2 + (KK2**2 + 4*KK2*y01)**0.5)/2
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
*     FUNCTION y3_fit
      y3_fit = y3
C
*     FUNCTION y4_fit
      y4_fit = y4
C
*     FUNCTION y5_fit
      y5_fit = y5
C
*     FUNCTION y6_fit
      y6_fit = y6
C
*     FUNCTION y7_fit
      y7_fit = y7
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

