C
C------------------------------------------------------
C
C     Problem:    BATCHREA
C
C     Date:       05.03.1996
C
C------------------------------------------------------
C
*     REAL CONSTANT
      E1 = 7.65E-18
      E2 = 4.03E-11
      E3 = 5.32E-18
      sc = 1.0E9
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      k1, km1, k2, k3, km3
      u1, u2, u3, u4, u5, u6, u7, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION u1_t
      u8 = E2*u1/(E2 + u7)
      u9 = E3*u3/(E3 + u7)
      u10 = E1*u5/(E1 + u7)
      u1_t = -k2*u2*u8
C
*     FUNCTION u2_t
      u2_t = -k1*u2*u6 + km1*sc*u10 - k2*u2*u8
C
*     FUNCTION u3_t
      u3_t = k2*u2*u8 + k3*u4*u6 - km3*sc*u9
C
*     FUNCTION u4_t
      u4_t = -k3*u4*u6 + km3*sc*u9
C
*     FUNCTION u5_t
      u5_t =  k1*u2*u6 - km1*sc*u10
C
*     FUNCTION u6_t
      u6_t = -k1*u2*u6 - k3*u4*u6 + km1*sc*u10 
     /    + km3*sc*u9
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION alg_equ
      u8 = E2*u1/(E2 + u7)
      u9 = E3*u3/(E3 + u7)
      u10 = E1*u5/(E1 + u7)
      alg_equ = -u7 - 0.0131 + u6 + u8 + u9 + u10
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION u1_0
      u1_0 = 1.5776
C
*     FUNCTION u2_0
      u2_0 = 8.32
C
*     FUNCTION u3_0
      u3_0 = 0
C
*     FUNCTION u4_0
      u4_0 = 0
C
*     FUNCTION u5_0
      u5_0 = 0
C
*     FUNCTION u6_0
      u6_0 = 0.0131
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION u7_0
      u7_0 = 0.5*(-E2 + sqrt(E2**2 + 4*E2*1.5776))
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit1
      fit1 = u1 
C
*     FUNCTION fit2
      fit2 = u2 
C
*     FUNCTION fit3
      fit3 = u3 
C
*     FUNCTION fit4
      fit4 = u4
C
*     FUNCTION fit5
      fit5 = u5 
C
*     FUNCTION fit6
      fit6 = u6
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C