C
C------------------------------------------------------
C
C     Problem:    BATCH
C
C     Date:       27.01.1997
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Qplus = 0.0131
      T = 373.15
      Tb = 342.15
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      q1, q2, q3, q4, q5, q6, q7, q8, q9
      x1, x2, x3, x4, x5, x6, x8, x9, x10, time
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_p
      k1 = exp(q1 - (1/T - 1/Tb)*exp(q7))
      k2 = exp(q2 - (1/T - 1/Tb)*exp(q8))
      km1 = exp(q3 - (1/T - 1/Tb)*exp(q9))
      x1_p = -k2*x2*x8
C
*     FUNCTION x2_p
      x2_p = -k1*x2*x6 + km1*x10 - k2*x2*x8
C
*     FUNCTION x3_p
      x3_p = k2*x2*x8 + k1*x4*x6 - 0.5*km1*x9
C
*     FUNCTION x4_p
      x4_p = -k1*x4*x6 + 0.5*km1*x9
C
*     FUNCTION x5_p
      x5_p = k1*x2*x6 + km1*x10 
C
*     FUNCTION x6_p
      x6_p = -k1*x2*x6 -k1*x4*x6 + km1*x10 + 0.5*km1*x9
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION a1
      kk1 = exp(-q4)
      kk2 = exp(-q5)      
      kk3 = exp(-q6)
      a1 =-x8*(kk2 + x6 + x8 + x9 + x10 - Qplus) + kk2*x1
C
*     FUNCTION a2
      a2 =-x9*(kk3 + x6 + x8 + x9 + x10 - Qplus) + kk3*x3
C
*     FUNCTION a3
      a3 =-x10*(kk1 + x6 + x8 + x9 + x10 - Qplus)+ kk1*x5
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      x1_0 = 1.5608
C
*     FUNCTION x2_0
      x2_0 = 8.3546
C
*     FUNCTION x3_0
      x3_0 = 0.0082
C
*     FUNCTION x4_0
      x4_0 = 0.0086
C
*     FUNCTION x5_0
      x5_0 = 0.0
C
*     FUNCTION x6_0
      x6_0 = 0.0131
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION x8_0
      x8_0 = 1.0
C
*     FUNCTION x9_0
      x9_0 = 1.0
C
*     FUNCTION x10_0
      x10_0 = 1.0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
*     FUNCTION x4_fit
      x4_fit = x4
C
*     FUNCTION x5_fit
      x5_fit = x5
C
*     FUNCTION x6_fit
      x6_fit = x6
C
*     FUNCTION x8_fit
      x8_fit = x8
C
*     FUNCTION x9_fit
      x9_fit = x9
C
*     FUNCTION x10_fit
      x10_fit = x10
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C







