C
C------------------------------------------------------
C
C     Problem:    BALLONS5
C
C     Date:       20.3.2000
C
C------------------------------------------------------
C
*     REAL CONSTANT
      XLENG1 = 0.0001
      XLENG2 = 0.0001
      XLENG3 = 0.0001
      XLENG4 = 0.0001
      XLENG5 = 0.0001
      PI = 3.1415926535
      C0  = 1.0
      C1  = 0.1
      R0  = 1.0 
      L1  =  XLENG1/R0
      L2  =  XLENG2/R0
      L3  =  XLENG3/R0
      L4  =  XLENG4/R0
      L5  =  XLENG5/R0
      L12 =  L1 + L2
      L123=  L1 + L2 + L3
      L1234= L1 + L2 + L3 + L4
      L12345= L1 + L2 + L3 + L4 + L5
      RA1 =  0.020/R0
      RI1 =  RA1 - L1
      RA2 =  0.040/R0
      RI2 =  RA2 - L2
      RA3 =  0.060/R0
      RI3 =  RA3 - L3
      RA4 =  0.0800/R0
      RI4 =  RA4 - L4
      RA5 =  0.1000/R0
      RI5 =  RA5-L5
      F1  = 4*PI*RI1**2
      F2  = 4*PI*RI2**2
      F3  = 4*PI*RI3**2
      F4  = 4*PI*RI4**2
      F5  = 4*PI*RI5**2
      V11  = 4/3*PI*RI1**3
      V12  = 4/3*PI*(RI2**3 - RI1**3)
      V13  = 4/3*PI*(RI3**3 - RI2**3)
      V14  = 4/3*PI*(RI4**3 - RI3**3)
      V15  = 4/3*PI*(RI5**3 - RI4**3)
      VG  = 4/3*PI*RI5**3
      DELTA  = 95.6884 - 95.1040153
      DELTAG = DELTA/(1 - C1/C0)*C1/C0 + DELTA
      DELTA1 = DELTA*V11/VG
      DELTA2 = DELTA*V12/VG
      DELTA3 = DELTA*V13/VG
      DELTA4 = DELTA*V14/VG
      DELTA5 = DELTA*V15/VG
      DELTAG1= DELTA1/(1 - C1/C0)*C1/C0 + DELTA1
      DELTAG2= DELTA2/(1 - C1/C0)*C1/C0 + DELTA2
      DELTAG3= DELTA3/(1 - C1/C0)*C1/C0 + DELTA3
      DELTAG4= DELTA4/(1 - C1/C0)*C1/C0 + DELTA4
      DELTAG5= DELTA5/(1 - C1/C0)*C1/C0 + DELTA5
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      D1S, D2S, D3S, D4S, D5S, U, UX, UXX, V1, V2, V3, V4, V5, X, T
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION UP1
      D1 = D1S*1.0D-6
      D2 = D2S*1.0D-6
      D3 = D3S*1.0D-6
      D4 = D4S*1.0D-6
      D5 = D5S*1.0D-6
      UP1 = D1*(2/(X + RI1)*UX + UXX)
C
*     FUNCTION UP2
      UP2 = D2*(2/(X + RI2 - L1)*UX + UXX)
C
*     FUNCTION UP3
      UP3 = D3*(2/(X + RI3 - L1 - L2)*UX + UXX)
C
*     FUNCTION UP4
      UP4 = D4*(2/(X + RI4 - L1 - L2 - L3)*UX + UXX)
C
*     FUNCTION UP5
      UP5 = D5*(2/(X + RI5 - L1 - L2 - L3 - L4)*UX + UXX) 
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION U1_0
      U1_0 = C1/C0
C
*     FUNCTION U2_0
      U2_0 = C1/C0
C
*     FUNCTION U3_0
      U3_0 = C1/C0
C
*     FUNCTION U4_0
      U4_0 = C1/C0
C
*     FUNCTION U5_0
      U5_0 = C1/C0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
*     FUNCTION VP1
      D2 = D1
      D3 = D1
      D4 = D1
      VP1 = R0**3*F1*D1*UX
C
*     FUNCTION VP2
      VP2 = R0**3*(F2*D2*UX - F1*D1*UX)
C
*     FUNCTION VP3
      VP3 = R0**3*(F3*D3*UX - F2*D2*UX)
C
*     FUNCTION VP4
      VP4 = R0**3*(F4*D4*UX - F3*D3*UX)
C
*     FUNCTION VP5
      VP5 = R0**3*(F5*D5*UX - F4*D4*UX)
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
*     FUNCTION V1_0
      V1_0 = 0
C
*     FUNCTION V2_0
      V2_0 = 0
C
*     FUNCTION V3_0
      V3_0 = 0
C
*     FUNCTION V4_0
      V4_0 = 0
C
*     FUNCTION V5_0
      V5_0 = 0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION U1_left
      U1_left = V1*DELTA1/DELTAG1 + C1/C0
C
*     FUNCTION U1_right
      U1_right = V2*DELTA2/DELTAG2 + C1/C0
C
*     FUNCTION U2_left
      U2_left = V2*DELTA2/DELTAG2 + C1/C0
C
*     FUNCTION U2_right
      U2_right = V3*DELTA3/DELTAG3 + C1/C0
C
*     FUNCTION U3_left
      U3_left = V3*DELTA3/DELTAG3 + C1/C0
C
*     FUNCTION U3_right
      U3_right = V4*DELTA4/DELTAG4 + C1/C0
C
*     FUNCTION U4_left
      U4_left = V4*DELTA4/DELTAG4 + C1/C0
C
*     FUNCTION U4_right
      U4_right = V5*DELTA5/DELTAG5 + C1/C0
C
*     FUNCTION U5_left
      U5_left = V5*DELTA5/DELTAG5 + C1/C0
C
*     FUNCTION U5_right
      U5_right = C0/C0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
C*     FUNCTION u_x_left
C      u_x_left = ...
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION FIT
      FIT = (V1*V11 + V2*V12 + V3*V13 + V4*V14 + V5*V15)/VG
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
