C
C------------------------------------------------------
C
C     Problem:    BALL
C
C     Date:       25.11.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      alpha = 0.9
      nu = 1
      b = 2
C
C------------------------------------------------------
C
*     PARAMETER
      n = 5   
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..n
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      tm(i), i in ind
      y, v, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y_t
      y_t = v
C
*     FUNCTION v_t
      v_t = -b
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y_0
      if (t.eq.0) then
        y_0 = 0
      else
        y_0 = y
      endif
C
*     FUNCTION v_0
      if (t.eq.0) then
        v_0 = nu
      else
        v_0 = -alpha*v
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y_fit
      y_fit = y
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g(i), i in ind
      g(i) = tm(i) - (1 - alpha**i)/(1 - alpha)*nu 
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


