C
C------------------------------------------------------
C
C     Problem:    BACTERIA
C
C     Date:       06.07.2004
C
C------------------------------------------------------
C
*     REAL CONSTANT 
      e = 2.718
      R0 = 0.33
      N0 = 10000
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      s1, s2, S, T0, EC50, N, C, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION N_t
      ER = S*C**s1/(C**s1 + EC50**s1)
      tmax = T0*(C**s2 + EC50**s2)/C**s2
      R = R0 - e*ER*t/tmax*exp(-t/tmax)
      N_t = R*N
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION N_0
      N_0 = N0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION N_fit
      N_fit = N
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
