C
C------------------------------------------------------
C
C     Problem:    AX_DIFF
C
C     Date:       26.11.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415926535
      K = 1
      R = 8.16
      E1 = 10000
      E2 = 20000
      v00 = 0.945
C 
C------------------------------------------------------
C
*     LININT u
      0.0  800.0
      0.2  805.0
      0.5  860.0
      0.8  855.0
      0.9  830.0
      1.0  800.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations(u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      Fs1, Fs2, v, v_x, v_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: all 
C     functions in first area, then all functions in
C     second area, etc.):
C
*     FUNCTION v_t
      F1 = Fs1*1000
      F2 = Fs2*100000
      v_t = v_xx - 2*K*v_x - K*((F1*exp(-E1/(R*u(t))) 
     /    + F2*exp(-E2/(R*u(t))))*v - F2*exp(-E2/(R*u(t))))
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: all initial values in 
C     first area, then all initial values in second 
C     area, etc.):
C
*     FUNCTION v_0
      v_0 = v00
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
c*     FUNCTION v_t
c      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
c*     FUNCTION u_left
c      u_left = ...
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION v_x_left
      if (t.le.0.5) then
        v0 = 0.6 - 0.4*cos(2*pi*t)
      else
        v0 = 1
      endif
      v_x_left = 2*K*(v - v0)
C
*     FUNCTION v_x_right
      v_x_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit
      fit = v
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

