C
C------------------------------------------------------
C
C     Problem:    AXDISP
C
C     Date:       12.02.01
C
C------------------------------------------------------
C 
*     SET OF INDICES
      IND=1..8
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      DL=100
      DG=100      
      Z0=160              
      M=0.6               
      HL=0.3               
      X0=1                     
      Y9=0   
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      L, G, K
      X1, X2, X3, X4, X5, X6, X7, X8
      Y1, Y2, Y3, Y4, Y5, Y6, Y7, Y8
      T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION X1P
      dZ=Z0/8                       
      HG=1-HL                  
      E3=L/(dZ*HL*2)  
      E4=DL/(dZ*dZ*HL)  
      E5=G/(dZ*HG*2)   
      E6=DG/(dZ*dZ*HG)  
      Y0=Y1+0.5*(Y1-Y2)   
      Q1=K*(X1-M*Y1)  
      Q2=K*(X2-M*Y2)  
      Q3=K*(X3-M*Y3)  
      Q4=K*(X4-M*Y4)  
      Q5=K*(X5-M*Y5)  
      Q6=K*(X6-M*Y6)  
      Q7=K*(X7-M*Y7)  
      Q8=K*(X8-M*Y8)  
      X1P=E3*(2*X0-X1-X2)+E4*(X2-X1)-Q1/HL
C
*     FUNCTION X2P
      X2P=-E3*(X3-X1)+E4*(X1-2*X2+X3)-Q2/HL
C
*     FUNCTION X3P
      X3P=-E3*(X4-X2)+E4*(X2-2*X3+X4)-Q3/HL
C
*     FUNCTION X4P
      X4P=-E3*(X5-X3)+E4*(X3-2*X4+X5)-Q4/HL
C
*     FUNCTION X5P
      X5P=-E3*(X6-X4)+E4*(X4-2*X5+X6)-Q5/HL
C
*     FUNCTION X6P
      X6P=-E3*(X7-X5)+E4*(X5-2*X6+X7)-Q6/HL
C
*     FUNCTION X7P
      X7P=-E3*(X8-X6)+E4*(X6-2*X7+X8)-Q7/HL
C
*     FUNCTION X8P
      X9=X8-0.5*(X7-X8)   
      X8P=E3*(X7+X8-2*X9)+E4*(X7-X8)-Q8/HL
C
*     FUNCTION Y1P
      Y1P=E5*(Y2+Y1-2*Y0)+E6*(Y2-Y1)+Q1/HG
C
*     FUNCTION Y2P
      Y2P=E5*(Y4-Y2)+E6*(Y1-2*Y2+Y3)+Q2/HG
C
*     FUNCTION Y3P
      Y3P=E5*(Y5-Y3)+E6*(Y2-2*Y3+Y4)+Q3/HG
C
*     FUNCTION Y4P
      Y4P=E5*(Y6-Y4)+E6*(Y3-2*Y4+Y5)+Q4/HG
C
*     FUNCTION Y5P
      Y5P=E5*(Y7-Y5)+E6*(Y4-2*Y5+Y6)+Q5/HG
C
*     FUNCTION Y6P
      Y6P=E5*(Y8-Y6)+E6*(Y5-2*Y6+Y7)+Q6/HG
C
*     FUNCTION Y7P
      Y7P=E5*(Y9-Y7)+E6*(Y6-2*Y7+Y8)+Q7/HG
C
*     FUNCTION Y8P
      Y8P=E5*(2*Y9-Y7-Y8)+E6*(Y7-X8)+Q8/HG
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X1_0(I), I IN IND
      X1_0(I)=0
C
*     FUNCTION Y1_0(I), I IN IND
      Y1_0(I)=0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION X1_fit
      X1_fit=X1
C
*     FUNCTION X2_fit
      X2_fit=X2
C
*     FUNCTION X3_fit
      X3_fit=X3
C
*     FUNCTION X4_fit
      X4_fit=X4
C
*     FUNCTION X5_fit
      X5_fit=X5
C
*     FUNCTION X6_fit
      X6_fit=X6
C
*     FUNCTION X7_fit
      X7_fit=X7
C
*     FUNCTION X8_fit
      X8_fit=X8
C
*     FUNCTION Y1_fit
      Y1_fit=Y1
C
*     FUNCTION Y2_fit
      Y2_fit=Y2
C
*     FUNCTION Y3_fit
      Y3_fit=Y3
C
*     FUNCTION Y4_fit
      Y4_fit=Y4
C
*     FUNCTION Y5_fit
      Y5_fit=Y5
C
*     FUNCTION Y6_fit
      Y6_fit=Y6
C
*     FUNCTION Y7_fit
      Y7_fit=Y7
C
*     FUNCTION Y8_fit
      Y8_fit=Y8
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
