C
C------------------------------------------------------
C
C     Problem:    ASYMP
C
C     Date:       10.2.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      eps = 0.000001
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a, b, v0, v, w, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION v_t
      v_t = w
C
*     FUNCTION w_t
      if (t.gt.0) then
        w_t = -a/(t+eps)*w - ((t+eps)*v - b)*v
      else
        w_t = v
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION v_0
      v_0 = v0
C
*     FUNCTION w_0
      w_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION v_fit
      v_fit = v
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
