C
C------------------------------------------------------
C
C     Problem:    ASTRO
C
C     Date:       10.2.1999
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      mue, u1, u2, v1, v2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION u1_t
      u1_t = v1
C
*     FUNCTION u2_t
      u2_t = v2
C
*     FUNCTION v1_t
      mue_hat = 1 - mue
      D1 = ((u1 + mue)**2 + u2**2)**1.5
      D2 = ((u1 - mue_hat)**2 + u2**2)**1.5
      v1_t = u1 + 2*v2 - mue_hat*(u1 + mue)/D1 
     /       - mue*(u1 - mue_hat)/D2 
C
*     FUNCTION v2_t
      v2_t = u2 - 2*v1 - mue_hat*u2/D1 - mue*u2/D2 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION u1_0
      u1_0 = 0.994
C
*     FUNCTION u2_0
      u2_0 = 0
C
*     FUNCTION v1_0
      v1_0 = 0
C
*     FUNCTION v2_0
      v2_0 = -2.001585106379082522405
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION u1_fit
      u1_fit = u1
C
*     FUNCTION u2_fit
      u2_fit = u2
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
