C
C------------------------------------------------------
C
C     Problem:    ASS_KIN5
C
C     Date:       3.2.1994
C
C------------------------------------------------------
C
*     REAL CONSTANT
      l10 = 5000
      l20 = 1000
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1p, k1m, r0, k2p, k2m, tau1, y1, y2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1P
      IF (T.ge.TAU1) THEN
        y1p = k1p*(r0 - y1 - y2)*(l10 - y1) - k1m*y1
      ELSE
        y1p = 0
      ENDIF
c
*     FUNCTION y2p
      y2p = k2p*(r0 - y1 - y2)*(l20 - y2) - k2m*y2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y10
      if (t.lt.0.00001) then
        y10 = 0
      else
        y10 = y1
      endif
C
*     FUNCTION y20
      if (t.lt.0.00001) then
        y20 = 0
      else
        y20 = Y2
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
