C
C------------------------------------------------------
C
C     Problem:    ASS_CV5
C
C     Date:       15.12.1994
C
C------------------------------------------------------
C
*     REAL CONSTANT
      l10 = 500
      l20 = 1000
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1p, k1m, r01, k2p, k2m, r02, a, y1, y2, y3, T       
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Y1P
      Y1P = k1p*(r01*exp(-k2m*a*t) - y1 - y3)*(l10 - y1) - k1m*y1
c
*     FUNCTION Y2P
      Y2P=k1p*(r02*exp(-k1m*a*t) - y2)*(l10 - y2) - k1m*y2
C
*     FUNCTION Y3P
      Y3P = k2p*(r01*exp(-k2m*a*t) - y1 - y3)*(l20 - y3) - k2m*y3
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Y10
      Y10 = 0
c
*     function y20
      y20=0
c
*     FUNCTION y30
      y30=0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Y1FIT
      Y1FIT = Y1
C
*     FUNCTION Y2FIT
      Y2FIT = Y2
C
*     FUNCTION Y3FIT
      Y3FIT = Y3
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
