C
C------------------------------------------------------
C
C     Problem:    ASS_CV4
C
C     Date:       28.2.1994
C
C------------------------------------------------------
C
*     REAL CONSTANT
      l1 = 335
      r0 = 20
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1p, k1m, r1, k2p, k2m, Y1, Y2, l2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Y1P
      if (l2.le.1) then
        Y1P = k1p*(r0 - y1 - y2)*(l1 - y1) - k1m*y1
      else
        Y1P = k1p*(r0 - y1 - y2*l2)*(l1 - y1) - k1m*y1
      endif
C
*     FUNCTION Y2P
      if (l2.le.1) then
        Y2P = k2p*(r0 - r1 - y1 - y2)*(l2 - y2) - k2m*y2
      else
        Y2P = k2p*(r0 - r1 - y1 - y2*l2)*(1 - y2) - k2m*y2
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Y10
      Y10 = 0
C
*     FUNCTION y20
      y20 = 0
C          
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Y1FIT
      Y1FIT = Y1
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
