C
C------------------------------------------------------
C
C     Problem:    ASS_CV3
C
C     Date:       3.2.1994
C
C------------------------------------------------------
C
*     REAL CONSTANT
      l10 = 5000
      l20 = 1000
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      K1p, k1m, r0, k2p, k2m, tau1, Y1, Y2, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Y1P
      IF (T.ge.tau1) THEN
        Y1P = k1p*(r0 - y1 - y2)*(l10 - y1) - k1m*y1
      ELSE
        Y1P = 0
      ENDIF
C
*     FUNCTION Y2P
      Y2P = k2p*(r0 - y1 - y2)*(l20 - y2) - k2m*y2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Y10 
      Y10 = 0
C
*     FUNCTION y20
      y20 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Y1FIT
      Y1FIT = Y1
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
