C
C------------------------------------------------------
C
C     Problem:    ASS_CV1
C
C     Date:       30.11.1994
C
C------------------------------------------------------
C
*     REAL CONSTANT
      l10 = 500
      l20 = 500
      l40 = 1000
      l60 = 5000
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      r01, r02, a, k1p, k1m, k2p, k2m, k4p, k4m, k6p, k6m
      y1, y2, y3, y4, y5, y6, y7, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1p
      y1p = k1p*(r01*dexp(-k2m*a*t) - y1 - y2)*(l10 - y1)
     /      - k1m*y1
C
*     FUNCTION y2p
      y2p = k2p*(r01*dexp(-k2m*a*t) - y1 - y2)*(l20 - y2)
     /      - k2m*y2
C
*     FUNCTION y3p
      y3p = k1p*(r01*dexp(-k4m*a*t) - y3 - y4)*(l10 - y3)
     /      - k1m*y3
C
*     FUNCTION y4p
      y4p = k4p*(r01*dexp(-k4m*a*t) - y3 - y4)*(l40 - y4)
     /      - k4m*y4
C
*     FUNCTION y5p
      y5p = k1p*(r01*dexp(-k6m*a*t) - y5 - y6)*(l10 - y5)
     /      - k1m*y5
C
*     FUNCTION y6p
      y6p = k6p*(r01*dexp(-k6m*a*t) - y5 - y6)*(l60 - y6)
     /      - k6m*y6
C
*     FUNCTION y7p
      y7p = k1p*(r02*dexp(-k1m*a*t) - y7)*(l10 - y7)
     /      - k1m*y7
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y10
      y10 = 0
C
*     FUNCTION y20
      y20 = 0
C
*     FUNCTION y30
      y30 = 0
C
*     FUNCTION y40
      y40 = 0
C
*     FUNCTION y50
      y50 = 0
C
*     FUNCTION y60
      y60 = 0
C
*     FUNCTION y70
      y70 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit1
      fit1 = y1
C
*     FUNCTION fit2
      fit2 = y7
C
*     FUNCTION fit3
      fit3 = y3
C
*     FUNCTION fit4
      fit4 = y5
C
*     FUNCTION fit5
      fit5 = y2
C
*     FUNCTION fit6
      fit6 = y4
C
*     FUNCTION fit7
      fit7 = y5
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
