C
C------------------------------------------------------
C
C     Problem:    ANHYD
C
C     Date:       06.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      G     = 4684     
      MM    = 0.02948  
      CP    = 0.25      
      H1    = -307     
      H3    = -1090   
      RHOB  = 1300    
      DP    = 3E-3      
      U     = 82.7    
      DT    = 0.025    
      R     = 1.897   
      TEMP0 = 650      
      XB0   = 0        
      XC0   = 0        
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      NO, NA0, TEMP, XB, XC, TJ, Z
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION TEMPP
      B1    = RHOB*MM/(G*NA0) 
      B2    = RHOB*(-H1)/(G*CP)   
      B3    = RHOB*(-H3)/(G*CP)   
      B4    = 4*U/(G*CP*DT)   
      XA    = XB + XC 
      NA    = NA0*(1-XA)  
      NB    = NA0*XB  
      K1    = 1000 * EXP(-27000/(R*TEMP) + 19.837)
      K2    = 1000 * EXP(-31400/(R*TEMP) + 20.86) 
      K3    = 1000 * EXP(-28600/(R*TEMP) + 18.97) 
      RA    = -(K1+K3)*NA*NO  
      RB    = K1*NA*NO - K2*NB*NO 
      RC    = K3*NA*NO + K2*NB*NO 
      TEMPP = B2*RB + B3*RC - B4*(TEMP-TJ)
C
*     FUNCTION XBP
      XBP   = B1*RB   
C
*     FUNCTION XCP
      XCP   = B1*RC   
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION TEMP_0
      TEMP_0 = TEMP0
C
*     FUNCTION XB_0
      XB_0 = XB0
C
*     FUNCTION XC_0
      XC_0 = XC0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION TEMP_fit
      TEMP_fit = TEMP
C
*     FUNCTION XB_fit
      XB_fit = XB
C
*     FUNCTION XC_fit
      XC_fit = XC
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
