C
C------------------------------------------------------
C
C     Problem:    ANAEMEAS
C
C     Date:       14.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      CGI  =   1E-3     
      CHI  =   1E-5      
      HYI  =   1E-5      
      MOIN   =   0.3      
      BUIN   =   0.00001   
      PRIN   =   0.00001  
      ACIN   =   0.00001   
      XMO  =  30.0         
      XBU  =  41.0        
      XAC  = 100.0         
      XPR  =   18.2      
      XHYD  =  2.0        
      KDBU  =   1.54E-2  
      KDPR  =   1.34E-2  
      KDAC  =   1.76E-2 
      KDC   =   3.02E-4 
      KW    =   1.0E-11 
      KDBUF =   6.9E-4  
      KSMO  =   0.25    
      KSBU  =   3.2E-2   
      KSPR  =   7.4E-3   
      KSHAC =   0.1      
      KIHAC =   1.4      
      KSHY  =   1.0E-3   
      UMAXMO  =   0.4     
      UMAXBU  =   0.011  
      UMAXPR  =   0.005    
      UMAXAC  =   0.008    
      UMAXHY  =   0.058   
      FBU  =   0.50
      FPR  =   0.12
      FAC  =   0.15
      FCO  =   0.23
      FHY  =   0.24
      UDMO  =   0.0004  
      UDBU  =   0.0004  
      UDPR  =   0.0004  
      UDAC  =   0.0004   
      UDHY  =   0.0004   
      YHYCO2 = 0.25
      HCO2  =  24.5  
      HCH4  =   1.12  
      HHY  =   0.74 
      VOLLI  =  0.00135 
      R  =8.314E-5 
      TEMP  = 310.0   
      P  =   1.0   
      PH2O  =   0.07  
      NN  =  40
      HSTART  =  1E-10  
      FAKCH0  =  10.
      EPSICH  =  0.03
      HPLUS  =   0.001   
      IONEN  =   0.5     
      BUFFER =   1      
      CO      =  0.10000E-09
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      YXMO, YXBU, YXPR, YXAC, YXHY, MO, BU, PR, AC, CG, HY, CH, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION DMO
      KINMO = UMAXMO*XMO*MO/(KSMO+MO)  
      CONSMO = KINMO/YXMO       
      DMO = -CONSMO           
C
*     FUNCTION DBU
      HBU = BU*HPLUS/(KDBU+HPLUS)  
      HAC = AC*HPLUS/(KDAC+HPLUS)   
      EQBU = 3.98E-10*(BU-HBU)/(((AC-HAC)**2)*(HY**2)*HPLUS)
      FEQBU = 0.0
      IF (EQBU.GT.1.0) THEN
        FEQBU = EQBU-1.0      
      ENDIF
      IF (EQBU.GT.2.0) THEN
        FEQBU = 1.0
      ENDIF
      KINBU = UMAXBU*XBU*HBU/(KSBU+HBU)*FEQBU  
      CONSBU = KINBU/YXBU            
      PROBU = CONSMO*FBU            
      DBU = PROBU-CONSBU             
C
*     FUNCTION DPR
      HPR = PR*HPLUS/(KDPR+HPLUS)       
      EQPR = 8.40E-12*2/3*(PR-HPR)/((AC-HAC)*(HY**3)*CO)
      FEQPR = 0.0
      IF (EQPR.GT.1.0) THEN
        FEQPR = EQPR-1.0 
      ENDIF
      IF (EQPR.GT.2.0) THEN
        FEQPR =1.0
      ENDIF
      KINPR = UMAXPR*XPR*HPR/(KSPR+HPR)*FEQPR
      CONSPR = KINPR/YXPR               
      PROPR = CONSMO*FPR             
      DPR = PROPR-CONSPR    
C
*     FUNCTION DAC
      KINAC = UMAXAC*XAC*HAC/(1+KSHAC+HAC**2/KIHAC)
      CONSAC = KINAC/YXAC              
      PROAC = CONSMO*FAC+CONSPR*0.667+CONSBU
      DAC = PROAC-CONSAC              
C
*     FUNCTION DCG
      FAKAC = KINAC/(XAC*UMAXAC)
      KINHY = UMAXHY*XHYD*HY/(KSHY+HY)     
      CONSHY = KINHY/YXHY             
      CONSCO = CONSHY*YHYCO2                
      PROCG = CONSMO*FCO+CONSPR*0.333+CONSAC*0.5 
      DCG = PROCG-CONSCO             
C
*     FUNCTION DHY
      PROHY = CONSMO*FHY+CONSPR+CONSBU*0.5   
      DHY = PROHY-CONSHY
C
*     FUNCTION DCH
      FAKHY = KINHY/(XHYD*UMAXHY)         
      PROCH = CONSAC*0.5+CONSHY*0.25      
      DCH = PROCH                       
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION MO_0
      MO_0=MOIN     
C
*     FUNCTION BU_0
      BU_0=BUIN
C
*     FUNCTION PR_0
      PR_0=PRIN
C
*     FUNCTION AC_0
      AC_0=ACIN
C
*     FUNCTION CG_0
      CG_0=CGI
C
*     FUNCTION HY_0
      HY_0=HYI
C
*     FUNCTION CH_0
      CH_0=CHI
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION MO_fit
      MO_fit=MO
C
*     FUNCTION BU_fit
      BU_fit=BU
C
*     FUNCTION PR_fit
      PR_fit=PR
C
*     FUNCTION AC_fit
      AC_fit=AC
C
*     FUNCTION CG_fit
      CG_fit=CG
C
*     FUNCTION HY_fit
      HY_fit=HY
C
*     FUNCTION CH_fit
      CH_fit=CH
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
