C
C------------------------------------------------------
C
C     Problem:  AMYLASE
C
C     Date:     22.04.96
C
C------------------------------------------------------
C
*     REAL CONSTANT
      state0 = 80.0
      state1 = 2.0 
      state2 = 0.5
      state3 = 0.01
      state4 = 0.0
      state5 = 8.076
      state6 = 275.85
      dV_in    = 600.0
      V_f      = 10.0
      V_g      = 2.5
      Y_XO     = 0.00147
      Y_XO_quo = 1.0/Y_XO
      Y_XS     = 0.51
      Y_XS_quo = 1.0/Y_XS
      c_g_in        = 275.85
      K_trans       = 0.65
      K             = 5.0
      K_m_St        = 5.0
      K_G           = 0.05
      k_L_a         = 1000.0
      K_St          = 0.5
      k_St_mRNA_max = 1.0
      k_St_Amy_max  = 5.0
      K_S_G         = 0.07
      K_S_c_l       = 0.1
      mu_mRNA       = 0.1
      mu_G_max      = 0.4
      mu_St_max     = 1.25
      M             = 0.02927
      r_St_max      = 5.0
      theta = 45.0
      pH    = 7.5
      exponent= exp(-log(2.0)*(pH - 7.5)*(pH - 7.5))
      pH1     = 1.0 - 0.8*exponent
      pH2     = 2.0 - exponent
      pH3     = exp(log(0.6)*(pH - 6.0)*(pH - 6.0))
      pH4     = 0.1 + 0.9*exponent
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      r_St, mu_G, mu_St, k_St_mRNA, k_St_Amy
      x0, x1, x2, x3, x4, x5, x6, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION dx0
C
      monod_St      = x0/(K_m_St  + x0)
      monod_G       = x1/(K_S_G   + x1)
      monod_c_l     = x5/(K_S_c_l + x5)
      henry         = M*x6 - x5
      abbau_St      = r_St*x3 * monod_St
      zell_wachstum = mu_G*monod_G*monod_c_l*x2
      dx0 = -abbau_St
C
*     FUNCTION dx1
      dx1 = abbau_St - zell_wachstum*Y_XS_quo
C
*     FUNCTION dx2
      dx2 = zell_wachstum - mu_St*K_St*x2/(K_St + x1)
C
*     FUNCTION dx3
      dx3 = x4
C
*     FUNCTION dx4
      dx4 = k_trans*mu_mRNA*x2 / (1 + exp(K*(x1 - K_G)))
     /      - (k_St_Amy + k_St_mRNA)*x4
     /      -  k_St_Amy*k_St_mRNA*x3
C
*     FUNCTION dx5
      dx5 = k_L_a*henry - zell_wachstum*Y_XO_quo
C
*     FUNCTION dx6
      dx6 = (-V_f*k_L_a*henry + dV_in*(c_g_in - x6))/V_g
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x01
      x01 = state1
C
*     FUNCTION x02
      x02 = state2
C
*     FUNCTION x03
      x03 = state3
C
*     FUNCTION x04
      x04 = state4
C
*     FUNCTION x05
      x05 = state5
C
*     FUNCTION x06
      x06 = state6
C
*     FUNCTION x07
      x07 = mu_G*state1/(K_m_St + state1)
     /      *state5/(K_S_c_l + state5)*state2*Y_XO_quo
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x0_fit
      x0_fit = x0
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
*     FUNCTION x4_fit
      x4_fit = x4
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
