C
C------------------------------------------------------
C
C     Problem:    AMMONAB
C
C     Date:       12.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      GM=0.053
      YIN=0.052
      YOUT=0.00263
      A=0.0059
      B=-0.1227
      C=3.01
      HABS=36200
      ATMOS=101.33
      TG=23
      TLIN=20
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      CP, KGA, LM, X, Y, TEMP, Z
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION XP
      K=A*TEMP*TEMP+B*TEMP+C
      YMF=Y/(1+Y)
      XMF=X/(1+X)
      YMFEQ=K*XMF/ATMOS
      DQ=KGA*(YMF-YMFEQ)
      XP=DQ/LM
C
*     FUNCTION YP
      YP=DQ/GM
C
*     FUNCTION TEMPP
      TEMPP=DQ*HABS/(LM*18*CP)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X_0
      X_0=0
C
*     FUNCTION Y_0
      Y_0=YOUT
C
*     FUNCTION TEMP_0
      TEMP_0=TLIN
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION X_fit
      X_fit=X
C
*     FUNCTION Y_fit
      Y_fit=Y
C
*     FUNCTION TEMP_fit
      TEMP_fit=TEMP
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
