C
C----------------------------------------------------------------
C
C     Problem:    AMIDPRO
C
C     Date:       3.4.95
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      kf, kn, ki, c, Ig, Ng, N, I, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION IgP
      IgP=-kf*Ig
C
*     FUNCTION NgP
      NgP=kf*(c - Ng)
C
*     FUNCTION NP
      NP=kf*I + 0.1*kn*(Ng-N)-0.9*kn*N
C
*     FUNCTION IP
      IP=-kf*I - 0.9*ki*I + 0.1*ki*N
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Ig0
      Ig0=0.8*c
C
*     FUNCTION Ng0
      Ng0=0.2*c
C
*     FUNCTION N0
      N0=0.2*c
C
*     FUNCTION I0
      I0=0.8*c
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION S
      S = I + N 
C
*     FUNCTION balance
      balance = (Ig + Ng - c)/c
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g
C      g = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

