C1  
C------------------------------------------------------
C  
C     Problem:    AMENTO
C  
C     Date:       29.5.2006
C  
C------------------------------------------------------
C     
*     REAL CONSTANT
      VC   = 0.0094
      Sm   = 4.7
      kon  = 0.001565
      koff = 0.00085
      Wtot = 0.5     
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C  
*     VARIABLE
      P, vk, C0ab, C0ba, km
      CAab, CBab, MCab, MmCab, CWAab, CWBab, CAba, CBba 
      MCba, MmCba, CWAba, CWBba
      t
C  
C------------------------------------------------------
C  
*     FUNCTION CAab_t  
      CCab = MCab/VC
      SA = 4.70576080 - 0.0074206*t + 0.000022341*t**2 - 0.0000000331*t**3
      VA = 1.630764 - 0.0021457*t + 0.0000064596*t**2 - 0.00000000957*t**3
      CAab_t = -P*(CAab - CCab)*Sm/VA + vk*Sm/VA - kon*CAab*(Wtot - CWAab)
     /         + koff*CWAab*SA/VA
C              
*     FUNCTION CBab_t
      SB = 26.8842921 - 0.0169706*t + 0.000051570*t**2 - 0.00000007563*t**3
      VB = 2.83076424 - 0.0021457*t + 0.0000064597*t**2 - 0.00000000957*t**3
      CBab_t = P*(CCab - CBab)*Sm/VB - kon*CBab*(Wtot - CWBab) + koff*CWBab*SB/VB
C             
*     FUNCTION MCab_t
      MCab_t = P*(CAab - CCab)*Sm - vk*Sm - P*(CCab - CBab)*Sm - km*MCab
C         
*     FUNCTION MmCab_t
      MmCab_t = km*MCab
C
*     FUNCTION CWAab_t
      CWAab_t = kon*CAab*(Wtot - CWAab)*VA/SA - koff*CWAab 
C
*     FUNCTION CWBab_t
      CWBab_t = kon*CBab*(Wtot - CWBab)*VB/SB - koff*CWBab
C
*     FUNCTION CAba_t
      CCba = MCba/VC
      CAba_t = P*(CCba - CAba)*Sm/VA + vk*Sm/VA - kon*CAba*(Wtot - CWAba)
     /         + koff*CWAba*SA/VA
C              
*     FUNCTION CBba_t
      CBba_t = -P*(CBba - CCba)*Sm/VB - kon*CBba*(Wtot - CWBba)
     /         + koff*CWBba*SB/VB
C
*     FUNCTION MCba_t
      MCba_t = P*(CBba - CCba)*Sm-P*(CCba - CAba)*Sm - vk*Sm - km*MCba
C   
*     FUNCTION MmCba_t
      MmCba_t = km*MCba
C
*     FUNCTION CWAba_t
      CWAba_t = kon*CAba*(Wtot - CWAba)*VA/SA - koff*CWAba                                                     
C
*     FUNCTION CWBba_t
      CWBba_t = kon*CBba*(Wtot - CWBba)*VB/SB - koff*CWBba    
C  
C------------------------------------------------------
C  
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C   
*     FUNCTION CAab_0      
      CAab_0 = C0ab
C
*     FUNCTION CBab_0
      CBab_0 = 0          
C
*     FUNCTION MCab_0
      MCab_0 = 0            
C    
*     FUNCTION MmCab_0
      MmCab_0 = 0
C            
*     FUNCTION CWAab_0
      CWAab_0 = 0
C
*     FUNCTION CWBab_0
      CWBab_0 = 0
C
*     FUNCTION CAba_0
      CAba_0 = 0
C
*     FUNCTION CBba_0
      CBba_0 = C0ba
C
*     FUNCTION MCba_0
      MCba_0 = 0                    
C     
*     FUNCTION MmCba_0
      MmCba_0 = 0
C
*     FUNCTION CWAba_0
      CWAba_0 = 0               
C
*     FUNCTION CWBba_0
      CWBba_0 = 0
C
C------------------------------------------------------
C  
C   - Fitting criteria:
C  
*     FUNCTION CAab_fit
      CAab_fit = CAab
C
*     FUNCTION CBab_fit
      CBab_fit = CBab
C
*     FUNCTION CAba_fit
      CAba_fit = CAba
C
*     FUNCTION CBba_fit
      CBba_fit = CBba
C
*     FUNCTION MmCab_fit
      MmCab_fit = 0.935*MmCab
C
*     FUNCTION MmCba_fit
      MmCba_fit = 0.935*MmCba   
C
*     FUNCTION MCab_fit
      MCab_fit = MCab
C
*     FUNCTION MCba_fit
      MCba_fit = MCba                
C
*     FUNCTION CWAab_fit
      CWAab_fit = CWAab
C
*     FUNCTION CWBab_fit
      CWBab_fit = CWBab
C
*     FUNCTION CWAba_fit
      CWAba_fit = CWAba
C
*     FUNCTION CWBba_fit
      CWBba_fit = CWBba
C      
C------------------------------------------------------
C  
C   - Constraints (if exist):
C         
C------------------------------------------------------
C  
*     END
C  
C------------------------------------------------------
C  

