C
C---------------------------------------------------------------
C
C     PROBLEM:   ALPHA_PI
C
C     Date:      12.3.1993
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      D1 , D2 , D3 , D4 , D5 , Y1 , Y2 , Y3 , Y4 , Y5 , T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Y1P
      Y1P = -(D1 + D2)*Y1
C
*     FUNCTION Y2P
      Y2P = D1*Y1
C
*     FUNCTION Y3P
      Y3P = D2*Y1 - (D3 + D4)*Y3 + D5*Y5     
C
*     FUNCTION Y4P
      Y4P = D3*Y3
C
*     FUNCTION Y5P
      Y5P = D4*Y3 - D5*Y5 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Y10
      Y10 = 10
C
*     FUNCTION Y20
      Y20 = 0
C
*     FUNCTION Y30
      Y30 = 0
C
*     FUNCTION Y40
      Y40 = 0
C
*     FUNCTION Y50
      Y50 = 0
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION Y1FIT
      Y1FIT = Y1
C
*     FUNCTION Y2FIT
      Y2FIT = Y2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
