C
C------------------------------------------------------
C
C     Problem:  AKTIV_W2
C
C     Date:     02.04.96
C
C------------------------------------------------------
C
*     REAL CONSTANT
      l10=500
      l20=500
      r100=350
      r0=500
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      krp, krm, k1p, k1m, k2p, k2m, k12, k21, r1, r2
      y1, y2
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION r1p
      r1p=krm*r2-krp*r1-k1p*(l10-y1)*r1+k1m*y1
C
*     FUNCTION r2p
      r2p=-krm*r2+krp*r1-k2p*(l20-y2)*r2+k2m*y2   
C
*     FUNCTION y1p
      y1p = k1p*r1*(l10-y1) - k1m*y1-k12*y1+k21*y2
C
*     FUNCTION y2p
      y2p = k2p*r2*(l20-y2) - k2m*y2+k12*y1-k21*y2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION r10
      r10=r100
c
*     FUNCTION r20
      r20=r0-r100
c
*     FUNCTION y10
      y10 = 0
C
*     FUNCTION y20
      y20 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION r1fit
      r1fit = r1
c
*     FUNCTION r2fit
      r2fit = r2
c
*     FUNCTION y1fit
      y1fit = y1
C
*     FUNCTION y2fit
      y2fit = y2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
