C
C------------------------------------------------------
C
C     Problem:    AIR_FLOW
C
C     Date:       22.10.1996
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind_fit = 1..8
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      gamma, rho, m, e, rho_x, m_x, e_x, rho_xx, m_xx, e_xx
      Frho,Fm, Fe, Frho_x, Fm_x, Fe_x
      x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION FLUX_rho
      FLUX_rho = -m
C
*     FUNCTION FLUX_m
      FLUX_m = -(m**2/rho + (gamma-1)*(e - 0.5*m**2/rho))
C
*     FUNCTION FLUX_e
      FLUX_e = -(m*e/rho + m/rho*(gamma-1)*(e - 0.5*m**2/rho))
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION rho_t
      rho_t = Frho_x 
C
*     FUNCTION m_t
      m_t = Fm_x
C
*     FUNCTION e_t
      e_t = Fe_x
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION rho_0
      if (x.lt.0.5) then
         rho_0 = 1
      else
         rho_0 = 0.125
      endif
C
*     FUNCTION m_0
      m_0 = 0
C
*     FUNCTION e_0
      if (x.lt.0.5) then
         e_0 = 2.5
      else
         e_0 = 0.25
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION p(i), i in ind_fit
      p(i) = (gamma - 1)*(e - m**2/(2*rho))
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C






