C
C------------------------------------------------------
C
C     Problem:    AIRLIFT
C
C     Date:       17.03.2003
C
C------------------------------------------------------
C
*     REAL CONSTANT
      F = 144000
      V = 2000
      Km = 1000000
      mm = 4.8
      Yxs = 1/0.38 
      Ke = 0.07
      Sinic = 280

C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      mumax, S, X, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION S_t
      mu = (mumax*S)/(Km + S)
      S_t = (F/V)*(Sinic - S) - Yxs*mu*X - mm*X
C
*     FUNCTION X_t
      X_t = (mu - Ke)*X
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION S_0
      S_0 = Sinic
C
*     FUNCTION X_0
      X_0 = 1500
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION X_fit
      X_fit = X
C
*     FUNCTION S_fit
      S_fit = S
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
