C
C------------------------------------------------------
C
C     Problem:    AEROSOLS
C
C     Date:       25.05.1995
C
C------------------------------------------------------
C
*     REAL CONSTANT
      L0I = 6.2
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      F0I, VG, VH, DLT, DGT, F0, M0, G0, L0, HUB
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Wirkstoff_per_Hub
      Z = F0/(F0 + L0)
      S = VH*DLT 
      Wirkstoff_per_Hub = -Z*S
C
*     FUNCTION Treibgas_per_Hub
      Treibgas_per_Hub = -(1 - Z)*S
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION Massenbilanz
      Massenbilanz = L0 + G0 - M0
C
*     FUNCTION Volumenbilanz
      Volumenbilanz = L0/DLT + G0/DGT - VG
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Wirkstoff_zu_Beginn
      Wirkstoff_zu_Beginn = F0I
C
*     FUNCTION Treibgas_zu_Beginn
      Treibgas_zu_Beginn = L0I + (VG - L0I/DLT)*DGT
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION Gasanteil_zu_Beginn
      Gasanteil_zu_Beginn = (VG - L0I/DLT)*DGT
C
*     FUNCTION Fluessigk_zu_Beginn
      Fluessigk_zu_Beginn = L0I
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Wirkstoffmasse
      Wirkstoffmasse = F0
C
*     FUNCTION Treibgasmasse
      Treibgasmasse = M0
C
*     FUNCTION Gasanteil
      Gasanteil = G0 
C
*     FUNCTION Fluessiganteil
      Fluessiganteil = L0
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C

