C
C------------------------------------------------------
C
C     Problem:    AEROSOL
C
C     Date:       25.05.1995
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Vh = 0.05
      Vn = 1.28
      Vg = 15.2 - Vn
      F0_initial = 0.026
      M0_initial = 13.5173
C
C------------------------------------------------------
C
*     SPLINE S_INT
      0.0    53.0
      10.0   53.5
      20.0   53.5
      30.0   52.8
      40.0   53.3
      50.0   53.5
      60.0   52.8
      70.0   52.8
      80.0   52.9
      90.0   53.5 
      100.0  53.1         
      110.0  53.3
      120.0  52.7
      130.0  52.3
      140.0  52.5
      150.0  52.8
      160.0  52.9
      170.0  52.8
      180.0  52.9 
      190.0  52.8 
      200.0  52.4
      205.0  52.9
      210.0  52.2
      215.0  52.7
      220.0  52.5
      225.0  52.4
      230.0  52.5
      235.0  52.2
      240.0  52.0
      245.0  51.4
      250.0  5.4
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      L0, L1, G0, G1, F, M, G, L, i
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Wirkstoff_per_Hub
      z  = F/(F + L)
      DL = L1*i + L0
      DG = G1*i + G0
      D  = 1/DL - 1/DG
      s  = S_INT(i)*0.001
      Wirkstoff_per_Hub = -z*s
C
*     FUNCTION Treibgas_per_Hub
      Treibgas_per_Hub = -(1 - z)*s
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION Massenbilanz
      Massenbilanz = L + G - M
C
*     FUNCTION Volumenbilanz
      Volumenbilanz = L/DL + G/DG - Vg
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Wirkstoff_zu_Beginn
      Wirkstoff_zu_Beginn = F0_initial
C
*     FUNCTION Treibgas_zu_Beginn
      Treibgas_zu_Beginn = M0_initial
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION Gasanteil_zu_Beginn
      DL = L0
      DG = G0
      D = 1/DL - 1/DG
      Gasanteil_zu_Beginn = (M0_initial/DL - Vg)/D        
C
*     FUNCTION Fluessigk_zu_Beginn
      Fluessigk_zu_Beginn = (Vg - M0_initial/DG)/D
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Wirkstoffanteil
      SF=(F0_initial + (Vg - M0_initial/DG)/D)/F0_initial*100
      Wirkstoffanteil = F/(F + L)*SF
C
*     FUNCTION plot_F
      plot_F = F
C
*     FUNCTION plot_M
      plot_M = M
C
*     FUNCTION plot_G
      plot_G = G
C
*     FUNCTION plot_L
      plot_L = L
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C

