C
C------------------------------------------------------
C
C     Problem:    AEKIN
C
C     Date:       8.11.2000
C
C------------------------------------------------------
C
*     REAL CONSTANT
      R = 8.314
      ckat = 0.03
      sk1 = 1.0E+7
      sEA1 = 1.0E+4
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1inf, EA1, cA0, cE01, cE02, cE03, cE04, cE05
      cA, cE, cAE, Temp, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION cA_t
      F = 1
      k1 = k1inf*sk1*exp(-EA1*sEA1/(R*(Temp+273)))
      cA_t = -k1*ckat*cA*cE*F
C
*     FUNCTION cE_t
      cE_t = -k1*ckat*cA*cE
C
*     FUNCTION cAE_t
      cAE_t = k1*ckat*cA*cE
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION cA_0
      cA_0 = cA0
C
*     FUNCTION cE_0
      if (Temp.lt.1) then
        cE_0 = cE01
      else
      if (Temp.lt.11) then
        cE_0 = cE02
      else
      if (Temp.lt.21) then
        cE_0 = cE03
      else
      if (Temp.lt.31) then
        cE_0 = cE04
      else
      if (Temp.lt.41) then
        cE_0 = cE05
      endif
      endif
      endif
      endif
      endif     
C
*     FUNCTION cAE_0
      cAE_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION cA_fit
      cA_fit = cA
C
*     FUNCTION cE_fit
      cE_fit = cE
C
*     FUNCTION cAE_fit
      cAE_fit = cAE
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

