C
C------------------------------------------------------
C
C     Problem:    ADV_DOMS
C
C     Date:       21.09.2001
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations(u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      D, u
      c, JD, Ju, c_x, JD_x, Ju_x, c_xx, JD_xx, Ju_xx
      fc, fJD, fJu, fc_x, fJD_x, fJu_x
      x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION flux_u
      flux_u = -u*c
C
*     FUNCTION flux_JD
      flux_JD = -u*JD
C
*     FUNCTION flux_Ju
      flux_Ju = -u*Ju 
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: all 
C     functions in first area, then all functions in
C     second area, etc.):
C
*     FUNCTION c_t
      c_t = fc_x + D*c_xx
C
*     FUNCTION JD_t
      JD_t = fJD_x + D*JD_xx + c_xx
C
*     FUNCTION Ju_t
      Ju_t = fJu_x + D*Ju_xx - c_x
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: all initial values in 
C     first area, then all initial values in second 
C     area, etc.):
C
*     FUNCTION c_0
      c_0 = 0
C
*     FUNCTION JD_0
      JD_0 = 0
C
*     FUNCTION Ju_0
      Ju_0 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
c*     FUNCTION v_t
c      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION c_left
      if (t.gt.0) then
        c_left = 10*exp(-0.001*(t - 7500)**2/t)
      else
        c_left = 0
      endif
C
*     FUNCTION JD_left
      JD_left = 0
C
*     FUNCTION Ju_left
      Ju_left = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
C*     FUNCTION u_x_left
C      u_x_left = ...
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit_c
      fit_c = c
C
*     FUNCTION fit_JD
      fit_JD = JD
C
*     FUNCTION fit_Ju
      fit_Ju = Ju
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C









