C
C------------------------------------------------------
C
C     Problem:    ADV_DIFF
C
C     Date:       19.1.2000
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415926535
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..5
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      a, b, u1, u2, u3, u1_x, u2_x, u3_x, u1_xx, u2_xx, u3_xx,
     /      f1, f2, f3, f1_x, f2_x, f3_x, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION flux1
      flux1 = a*u1**2*(1 - u1**2)
C
*     FUNCTION flux2
      flux2 = a*u2**2*(1 - u2**2)
C
*     FUNCTION flux3
      flux3 = a*u3**2*(1 - u3**2)
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION u1_t
      eps = 0.1
      u1_t = -(1 + b*sin(pi*x)/a)*f1_x + eps*u1_xx
C
*     FUNCTION u2_t
      eps = 0.01
      u2_t = -(1 + b*sin(pi*x)/a)*f2_x + eps*u2_xx
C
*     FUNCTION u3_t
      eps = 0.005
      u3_t = -(1 + b*sin(pi*x)/a)*f3_x + eps*u3_xx
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION u1_0
      if (x.gt.0) then
        u1_0 = -1
      else
        u1_0 = 1
      endif
C
*     FUNCTION u2_0
      if (x.gt.0) then
        u2_0 = -1
      else
        u2_0 = 1
      endif
C
*     FUNCTION u3_0
      if (x.gt.0) then
        u3_0 = -1
      else
        u3_0 = 1
      endif
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
c*     FUNCTION v_t
c      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION u1_left
      u1_left = 1
C
*     FUNCTION u2_left
      u2_left = 1
C
*     FUNCTION u3_left
      u3_left = 1
C
*     FUNCTION u1_right
      u1_right = -1
C
*     FUNCTION u2_right
      u2_right = -1
C
*     FUNCTION u3_right
      u3_right = -1
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
C*     FUNCTION u_x_left
C      u_x_left = ...
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit11
      fit11 = u1
C
*     FUNCTION fit12
      fit12 = u2
C
*     FUNCTION fit13
      fit13 = u3
C
*     FUNCTION fit21
      fit21 = u1
C
*     FUNCTION fit22
      fit22 = u2
C
*     FUNCTION fit23
      fit23 = u3
C
*     FUNCTION fit31
      fit31 = u1
C
*     FUNCTION fit32
      fit32 = u2
C
*     FUNCTION fit33
      fit33 = u3
C
*     FUNCTION fit41
      fit41 = u1
C
*     FUNCTION fit42
      fit42 = u2
C
*     FUNCTION fit43
      fit43 = u3
C
*     FUNCTION fit51
      fit51 = u1
C
*     FUNCTION fit52
      fit52 = u2
C
*     FUNCTION fit53
      fit53 = u3
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
