C
C------------------------------------------------------
C
C     Problem:    ADVECT_N
C  
C     Date:       2.8.99
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..8
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      p, u, J, u_x, J_x, u_xx, J_xx, f, g, f_x, g_x, x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION flux_f
      flux_f = -u
C
*     FUNCTION flux_g
      flux_g = -J
C
*     FUNCTION u_t
      u_t = f_x + p*u*(u - 1)*(u - 0.5)
C
*     FUNCTION J_t
      J_t = g_x + u*(u - 1)*(u - 0.5) + p*J*(u - 1)*(u - 0.5)
     /                     + p*u*J*(u - 0.5) + p*u*(u - 1)*J
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_0  
      delta = p*(0.1 - x) 
      if (delta.gt.0) then
        delta = 0
      endif
      if (delta.lt.-1) then
        delta = -1
      endif    
      u_0 = delta + 1
C
*     FUNCTION J_0  
      delta = 0.1 - x 
      if (delta.gt.0) then
        delta = 0
      endif
      if (delta.lt.-1) then
        delta = 0
      endif    
      J_0 = delta 
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION u_l
      u_l = 1
C
*     FUNCTION J_l
      J_l = 0
C      
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit(i), i in ind
      fit(i)= u 
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C




