C
C------------------------------------------------------
C
C     Problem:    ADVECT2
C
C     Date:       14.03.97
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). these names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      v1, v2, T1, T2, T1_x, T2_x, T1_xx, T2_xx,
     /                 f1, f2, f1_x, f2_x, x, time
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION flux11
      flux11 = -v1*T1
C
*     FUNCTION flux21
      flux21 = -v2*T2
C
*     FUNCTION flux12
      flux12 = -v1*T1
C
*     FUNCTION flux22
      flux22 = -v2*T2
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION T11_p
      T11_p = f1_x
C
*     FUNCTION T21_p
      T21_p = f2_x
C
*     FUNCTION T12_p
      T12_p = f1_x
C
*     FUNCTION T22_p
      T22_p = f2_x
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION T11_0
      T11_0 = 1.0
C
*     FUNCTION T21_0
      T21_0 = 1.0
C
*     FUNCTION T12_0
      T12_0 = 1.0
C
*     FUNCTION T22_0
      T22_0 = 1.0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION T11_left
      T11_left = 0
C
*     FUNCTION T22_left
      T22_left = T2
C
*     FUNCTION T11_right
      T11_right = T1
C
*     FUNCTION T22_right
      T22_right = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
c*     FUNCTION T22_x_left
c      T22_x_left = ...
C
c*     FUNCTION T11_x_right
c      T11_x_right = ...
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit1
      fit1 = T1 
C
*     FUNCTION fit2
      fit2 = T2 
C
*     FUNCTION fit3
      fit3 = T1 
C
*     FUNCTION fit4
      fit4 = T2 
C
*     FUNCTION fit5
      fit5 = T1 
C
*     FUNCTION fit6
      fit6 = T2 
C
*     FUNCTION fit7
      fit7 = T1 
C
*     FUNCTION fit8
      fit8 = T2 
C
*     FUNCTION fit9
      fit9 = T1 
C
*     FUNCTION fit10
      fit10 = T2 
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



