C
C------------------------------------------------------
C
C     Problem:    ADVECT2
C
C     Date:       14.03.97
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      v1, v2, T1, T2, T1_x, T2_x, T1_xx, T2_xx,
     /                 f1, f2, f1_x, f2_x, x, time
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION flux1
      flux1 = -v1*T1
C
*     FUNCTION flux2
      flux2 = -v2*T2
C
*     FUNCTION T1_p
      T1_p = f1_x
C
*     FUNCTION T2_p
      T2_p = f2_x
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION T1_0
      T1_0 = 1.0
C
*     FUNCTION T2_0
      T2_0 = 1.0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION T1_l
      T1_l = 0.0
C
*     FUNCTION T2_r
      T2_r = 0.0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit1
      fit1 = T1 
C
*     FUNCTION fit2
      fit2 = T2 
C
*     FUNCTION fit3
      fit3 = T1 
C
*     FUNCTION fit4
      fit4 = T2 
C
*     FUNCTION fit5
      fit5 = T1 
C
*     FUNCTION fit6
      fit6 = T2 
C
*     FUNCTION fit7
      fit7 = T1 
C
*     FUNCTION fit8
      fit8 = T2 
C
*     FUNCTION fit9
      fit9 = T1 
C
*     FUNCTION fit10
      fit10 = T2 
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

