C
C------------------------------------------------------
C
C     Problem:    ADI_CSTR
C  
C     Date:       08.09.98
C
C------------------------------------------------------
C
*     REAL CONSTANT
      tau = 100
      Hr = 4180
      Tr = 800
      rho = 1
      Cp = 4.18
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind10 = 1..10
C
C------------------------------------------------------
C
*     INDEX
      j
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      x1, x2
      z1(i), i in ind10 
      z2(i), i in ind10 
      z3(i), i in ind10 
      z4(i), i in ind10 
      z5(i), i in ind10 
      mue
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1
      IF (mue.LT.1.5) THEN
        j = 1
      ELSE
      IF (mue.LT.2.5) THEN
        j = 2
      ELSE
      IF (mue.LT.3.5) THEN
        j = 3
      ELSE
      IF (mue.LT.4.5) THEN
        j = 4
      ELSE
      IF (mue.LT.5.5) THEN
        j = 5
      ELSE
      IF (mue.LT.6.5) THEN
        j = 6
      ELSE
      IF (mue.LT.7.5) THEN
        j = 7
      ELSE
      IF (mue.LT.8.5) THEN
        j = 8
      ELSE
      IF (mue.LT.9.5) THEN
        j = 9
      ELSE
        j = 10
      ENDIF
      ENDIF
      ENDIF
      ENDIF
      ENDIF
      ENDIF
      ENDIF      
      ENDIF
      ENDIF
      y1 = z1(j)
C
*     FUNCTION y2
      y2 = z2(j)
C
*     FUNCTION y3
      y3 = z3(j) 
C
*     FUNCTION y4
      y4 = z4(j)
C
*     FUNCTION y5
      y5 = z5(j)
C
C------------------------------------------------------
C
C   - Constraints:
C
*     FUNCTION g1(i), i in ind10
      k1 = x1*exp(-x2*(Tr/z5(i) - 1))
      g1(i) = (z1(i) - z2(i))/tau - k1*z2(i)
C
*     FUNCTION g2(i), i in ind10
      g2(i) = -z3(i)/tau + k1*z1(i)
C
*     FUNCTION g3(i), i in ind10
      g3(i) = (z4(i) - z5(i))/tau + Hr/(rho*Cp)*k1*z1(i)
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C










