C
C------------------------------------------------------
C
C     Problem:    ADIABATI
C
C     Date:       15.12.1999
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a, b, na, nb, Vr
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION na_Vr
      T = 350 + 1500*(2.1 - 2*na - nb)/(9 + 10*na - 20*nb)
      k1 = exp(1.9152 - 1091.7/T)
      k2 = exp(1.2222 - 1091.7/T)
      F = 0.0164*T*(0.6 + na - nb)
      na_Vr = -na*(k1*nb + k2*(na - 3*nb))/F**2
C
*     FUNCTION nb_Vr
      nb_Vr = k1*na*nb/F**2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION na_0
      na_0 = a
C
*     FUNCTION nb_0
      nb_0 = b
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION na_fit
      na_fit = na
C
*     FUNCTION nb_fit
      nb_fit = nb
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

