C
C------------------------------------------------------
C
C     Problem:    ACTNITR
C
C     Date:       13.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      V1=100
      V2=100
      R=0.95
      C=2 
      S0=1
      A0=0.1 
      K1=0.5
      K2=1.0   
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      U1M, U2M, Y1, Y2, S1, A1, O1, N1, S2, A2, O2, N2, F0, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION S1P
      R1=U1M*S1*O1/(K1+S1)
      R2=U2M*A1*N1/(K2+A1)
      F2=F0*R 
      F1=F2+F0
      F3=F1/C 
      F4=F1-F3
      S1P=(F0*S0+F2*S2-F1*S1-R1*V1/Y1)/V1 
C
*     FUNCTION A1P
      A1P=(F0*A0+F2*A2-F1*A1-R2*V1/Y2)/V1 
C
*     FUNCTION O1P
      O1P=(F2*O2-F1*O1+R1*V1)/V1  
C
*     FUNCTION N1P
      N1P=(F2*N2-F1*N1+R2*V1)/V1  
C
*     FUNCTION S2P
      S2P=(F1*S1-F3*S2-F4*S2)/V2  
C
*     FUNCTION A2P
      A2P=(F1*A1-F3*A2-F4*A2)/V2  
C
*     FUNCTION O2P
      O2P=(F1*O1-F3*O2)/V2
C
*     FUNCTION N2P
      N2P=(F1*N1-F3*N2)/V2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION S1_0
      S1_0=0.05
C
*     FUNCTION A1_0
      A1_0=0.05 
C
*     FUNCTION O1_0
      O1_0=2
C
*     FUNCTION N1_0
      N1_0=2 
C
*     FUNCTION S2_0
      S2_0=0.05
C
*     FUNCTION A2_0
      A2_0=0.05 
C
*     FUNCTION O2_0
      O2_0=2
C
*     FUNCTION N2_0
      N2_0=2 
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION S2_fit
      S2_fit=S2
C
*     FUNCTION A2_fit
      A2_fit=A2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
