C  
C------------------------------------------------------
C
C     Problem:    ACETYL_T
C  
C     Date:       6.06.1997
C  
C------------------------------------------------------
C  
*     SET OF INDICES
      IND8=1..8
      IND9=1..9
C  
C------------------------------------------------------
C  
*     REAL CONSTANT
      AINI=0.1
      CINI=0.0001
      R=8.314
      E1=2.7E+4
      E2=3.8E+4
      E3=3.4E+4
      E4=3.2E+4
      E5=3.0E+4
      TEMPR=873.15
      TEMP0=873.15
      A1=0.72
      A2=0.56
      MP1=500.0
      MP2=500.0
      MP=1000.0
      RHO0=47.02E-3
      EPSR=0.999
      DH1=-263.0E+3
      DH2=277.5E+3
      DH3=283.0E+3
      DH4=226.7E+3
      DH5=241.8E+3
      BETA=1.4E-5
      C10=1.469E-3
      C20=0.734E-3
      K1=1.80E+04
      K2=9.00E+06
      K3=2.60E+05
      K4=8.90E+02
      K5=3.60E+04    
      EPS=1.0E-16
C
C------------------------------------------------------
C
*     TABLE MM(I), I IN IND8
      1  16.0
      2  32.0
      3  26.0
      4  44.0
      5   2.0
      6  28.0
      7  18.0
      8 114.0
C
*     TABLE CPK(I), I IN IND8
      1  2.219
      2  0.917
      3  1.683
      4  0.837
      5  14.32
      6  1.042
      7  2.5
      8  1.595
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first space derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second space derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. space variable (x)
C     7. time variable (t)
C
*     VARIABLE
      C1_CTRL, C2_CTRL
      A
      C(I), I IN IND9
      AZ
      CZ(I), I IN IND9
      AZZ
      CZZ(I), I IN IND9
      Z, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION A_T
      TEMP=C(9)
      IF (C(3).GT.EPS) THEN
        C31=C(3)**A2
      ELSE
        IF (C(3).LT.-EPS) THEN
          C31=(-C(3))**A2
        ELSE
          C31=0
        ENDIF
      ENDIF          
      IF (TEMP.LE.EPS) THEN
         R4=1.0E-7
      ELSE   
         R4=K4*DEXP(-E4/R*(1/TEMP - 1/TEMPR))*C31
      ENDIF  
      A_T = -BETA*R4
C
*     FUNCTION CP1
      TEMP=C(9)
      RHO=SUM(C(I)*MM(I), I IN IND8)
      IF (RHO.GT.EPS) THEN
        CPZT=SUM(C(I)*MM(I)*CPK(I), I IN IND8)/RHO
      ELSE
        CPZT=1
        RHO=0.00001
      ENDIF  
      IF (A.LE.EPS) THEN
         V=1.0E-7
      ELSE
         V=MP/(RHO*A)
      ENDIF  
      IF (C(1).GT.EPS) THEN
        C11=C(1)**A1
      ELSE
        IF (C(1).LT.-EPS) THEN
          C11=(-C(1))**A1
        ELSE
          C11=0
        ENDIF
      ENDIF
      IF (C(2).GT.EPS) THEN
        C21=C(2)**A2
        C22=C(2)**0.5
      ELSE
        IF (C(2).LT.-EPS) THEN
          C21=(-C(2))**A2
          C22=(-C(2))**0.5
        ELSE
          C21=0
          C22=0
        ENDIF
      ENDIF
      IF (C(3).GT.EPS) THEN
        C31=C(3)**A2
      ELSE
        IF (C(3).LT.-EPS) THEN
          C31=(-C(3))**A2
        ELSE
          C31=0
        ENDIF
      ENDIF
      R1=K1*DEXP(-E1/R*(1/TEMP - 1/TEMPR))*C11
      R2=K2*DEXP(-E2/R*(1/TEMP - 1/TEMPR))*C(1)*C21
      R3=K3*DEXP(-E3/R*(1/TEMP - 1/TEMPR))*C(6)*C22
      R4=K4*DEXP(-E4/R*(1/TEMP - 1/TEMPR))*C31
      R5=K5*DEXP(-E5/R*(1/TEMP - 1/TEMPR))*C(5)*C22
      CP1 = V*CZ(1) + R1 + R2
C
*     FUNCTION CP2
      CP2 = CZ(2) - (-R2 - 0.5*R3 - 0.5*R5)/V
C
*     FUNCTION CP3
      CP3 = CZ(3) - (0.5*R1 - R4)/V
C
*     FUNCTION CP4
      CP4 = CZ(4) - R3/V
C
*     FUNCTION CP5
      CP5 = CZ(5) - (1.5*R1 + R2  + R4 - R5)/V
C
*     FUNCTION CP6
      CP6 = CZ(6) - (R2 - R3)/V
C
*     FUNCTION CP7
      CP7 = CZ(7) - (R2 + R5)/V
C
*     FUNCTION CP8
      CP8 = CZ(8) - 2*(1 - EPSR)*R4/V
C
*     FUNCTION CP9                  
      VX=RHO*V*CPZT
      IF (VX.GT.EPS) THEN
         CP9=0.00001*(CZ(9) - (R1*DH1 + R2*DH2 + R3*DH3
     /          + R4*DH4 + R5*DH5)/VX)
      ELSE
        CP9=0.0
      ENDIF   
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION A_0 
      A_0 = AINI
C
*     FUNCTION C1_0
      C1_0 = CINI  
C
*     FUNCTION C2_0
      C2_0 = CINI
C
*     FUNCTION C3_0
      C3_0 = CINI
C
*     FUNCTION C4_0
      C4_0 = CINI
C
*     FUNCTION C5_0
      C5_0 = CINI
C
*     FUNCTION C6_0
      C6_0 = CINI
C
*     FUNCTION C7_0
      C7_0 = CINI
C
*     FUNCTION C8_0
      C8_0 = CINI
C
*     FUNCTION C9_0
      C9_0 = TEMP0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION C1_L
      C1_L = C1_CTRL*0.001
C
*     FUNCTION C2_L
      C2_L = C2_CTRL*0.001
C
*     FUNCTION C3_L
      C3_L = CINI
C
*     FUNCTION C4_L
      C4_L = CINI
C
*     FUNCTION C5_L
      C5_L = CINI
C
*     FUNCTION C6_L
      C6_L = CINI
C
*     FUNCTION C7_L
      C7_L = CINI
C
*     FUNCTION C8_L
      C8_L = CINI
C
*     FUNCTION C9_L
      C9_L = TEMP0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FIT(I), I IN IND9
      FIT(I) = C(I)
C
*     FUNCTION A_FIT
      A_FIT = A
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


