C
C------------------------------------------------------
C
C     Problem:    ACCRET_A
C
C     Date:       17.09.99
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415926535 
      Br0 = 1
      Bt0 = 1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      Dz, 
     /      Br, Bt, f1, f2, f3, f4, 
     /      Br_z, Bt_z, f1_z, f2_z, f3_z, f4_z, 
     /      Br_zz, Bt_zz, f1_zz, f2_zz, f3_zz, f4_zz,
     /      FBr, FBt, Ff1, Ff2, Ff3, Ff4, 
     /      FBr_z, FBt_z, Ff1_z, Ff2_z, Ff3_z, Ff4_z, 
     /      z, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION flux_Br 
      rho = exp(-z**2)
      flux_Br = -f1*Bt + rho*Dz*(Br_z/rho + Br*2*z/rho) - f2*Br
C
*     FUNCTION flux_Bt 
      flux_Bt = rho*Dz*(Bt_z/rho + Bt*2*z/rho) + f3*Bt
C
*     FUNCTION flux_f1
      flux_f1 = 1
C
*     FUNCTION flux_f2
      flux_f2 = -0.2
C
*     FUNCTION flux_f3
      flux_f3 = 0.1
C
*     FUNCTION flux_f4
      flux_f4 = -0.02
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION Br_t
      Br_t = FBr_z
C
*     FUNCTION Bt_t
      Bt_t = -3/2*Br + FBt_z
C
*     FUNCTION A1
      if (z.eq.0) then
        Dzz = 0
      else
        Dzz = Dz/z
      endif
      A1 = f2 - f3 + Dzz/2
C
*     FUNCTION A2
      A2 = f1*Dzz/2 + f2/2 - f4
C
*     FUNCTION A3
      A3 = f2 + f3 + f4*Dzz
C
*     FUNCTION A4
      A4 = f1 + f2*Dzz/2 - f3 - Dzz/3
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION Br_0
      Br_0 = Br0*exp(-z**2)
C
*     FUNCTION Bt_0
      Bt_0 = Bt0*exp(-z**2)
C
*     FUNCTION f1_0
      f1_0 = 0
C
*     FUNCTION f2_0
      f2_0 = 0
C
*     FUNCTION f3_0
      f3_0 = 0
C
*     FUNCTION f4_0
      f4_0 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
C*     FUNCTION v_t
C      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 =...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION Br_right
      Br_right = 0
C
*     FUNCTION Bt_right
      Bt_right = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
C
*     FUNCTION Br_z_left
      Br_z_left = 0
C
*     FUNCTION Bt_z_left
      Bt_z_left = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit_Br
      fit_Br = Br
C
*     FUNCTION fit_Bt
      fit_Bt = Bt
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
