C
C------------------------------------------------------
C
C     Problem:    ACCRET
C
C     Date:       17.09.99
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415926535 
      Br0 = 1
      Bt0 = 1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      Dz, Br, Bt, Br_z, Bt_z, Br_zz, Bt_zz
      Fr, Ft, Fr_z, Ft_z, z, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION flux_Br 
      f1 = -0.001*z
      f2 = 0
      f3 = 0
      rho = exp(-z**2)
      flux_Br = -f1*Bt + rho*Dz*(Br_z/rho + Br*2*z/rho) - f2*Br
C
*     FUNCTION flux_Bt 
      flux_Bt = rho*Dz*(Bt_z/rho + Bt*2*z/rho) + f3*Bt
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION Br_t
      Br_t = Fr_z
C
*     FUNCTION Bt_t
      Bt_t = -3/2*Br + Ft_z
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION Br_0
      Br_0 = Br0*exp(-z**2)
C
*     FUNCTION Bt_0
      Bt_0 = Bt0*exp(-z**2)
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
C*     FUNCTION v_t
C      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 =...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION Br_right
      Br_right = 0
C
*     FUNCTION Bt_right
      Bt_right = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION Br_z_left
      Br_z_left = 0
C
*     FUNCTION Bt_z_left
      Bt_z_left = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit1_Br
      fit1_Br = Br
C
*     FUNCTION fit1_Bt
      fit1_Bt = Bt
C
*     FUNCTION fit2_Br
      fit2_Br = Br
C
*     FUNCTION fit2_Bt
      fit2_Bt = Bt
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
