C
C------------------------------------------------------
C
C     Problem:     ABSORP
C
C     Date:        22.03.00
C
C------------------------------------------------------
C
*     REAL CONSTANT
      c1 = 10000
      c3 = 2.25717
      cd = 10000
      lkh1 = 6.9561
      lkh2 = 4.2603
      nst = 2.0810E-5
      f1 = 0.45
      lkh1a = -0.80767
      lkh1m = -0.882029
      lkh1m2 = -10
      lkh1m2b = -10
      lkm2tet = -20
      lkh2a = -0.80767
      lkh2m = -0.882029
      lkh2m2 = -10
      lkh2m2b = -10
      sd = 0.99759
      ac1 = 0.85
      zh = 1
      zm = 1
      zm2 = 2
      za = -1
      zt1 = -0.32
      zt2 = -0.60
      tempk = 298.15
      mws = 58.44
      dw = 78.45
      lkw = -13.993
      lqw = -13.8492
      aw = 0.999
      mt2 = 0.001
      rc = 8.314
      faraday = 96487
      pv = 8.854E-12
      L10 = log(10)
C
C------------------------------------------------------
C
*     LININT mt
      2.86276  0.02984
      2.88055  0.02977
      3.11311  0.02917
      3.32981  0.02884
      3.53198  0.02863
      3.90556  0.02843
      4.20997  0.02834
      4.4036   0.0283
      4.72599  0.02827
      5.10103  0.02824
      5.50368  0.02821
      5.80622  0.02818
      6.22663  0.02816
      6.48496  0.02813
      6.82888  0.02811
      7.03207  0.02808
      7.41246  0.02805
      7.79945  0.02801
      8.32461  0.02796
      8.64953  0.02792
      9.17041  0.02785
      9.6287   0.02778
      10.10376 0.02769
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. system variables (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      c2
      ft1, ft2, spt, pot1, pot2, pot3, potd
      ph
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     nonlinear equations:
C
*     FUNCTION diffsuct
      ac2 = ac1**4
      pc = faraday/(rc*tempk)
      ns1 = nst*f1
      ns2 = nst*(1 - f1)
      dis = 1/((1/dw) + ((-0.206/dw)*mt(ph)) + (0.0051*mt(ph)))
      mtm = (mt(ph)*sd)/(1 + (0.001*mt(ph)*mws))
      xt = ((8*tempk*rc*pv*dis*mtm*1000)**0.5)
      t1h = ft1*ns1*Exp(L10*lkh1+L10*(-ph)-zh*spt*pc)
      t1m2 = ft1*ns1*mt2*ac2*Exp(L10*lkh1m2-zm2*pot1*pc)
      t1m2b = (ft1*ns1)**2*mt2*ac2*Exp(L10*lkh1m2b-zm2*pot1*pc)
      t1m = ft1*ns1*mt(ph)*ac1*Exp(L10*lkh1m-zm*pot2*pc)
      t1a = ft1*ns1*mt(ph)*ac1
     /  *Exp(L10*lkh1a+L10*lkh1+L10*(-ph)-za*pot3*pc-zh*spt*pc)
      t2h = ft2*ns2*Exp(L10*lkh2+L10*(-ph)-zh*spt*pc)
      t2m2 = ft2*ns2*mt2*ac2*Exp(L10*lkh2m2-zm2*pot1*pc)
      t2m2b = (ft2*ns2)**2*mt2*ac2*Exp(L10*lkh2m2b-zm2*pot1*pc)
      t2m = ft2*ns2*mt(ph)*ac1*Exp(L10*lkh2m-zm*pot2*pc)
      t2a = ft2*ns2*mt(ph)*ac1
     /  *Exp(L10*lkh2a+L10*lkh2+L10*(-ph)-za*pot3*pc-zh*spt*pc)
      t1t2m2tet = (ft1*ns1)**2*(ft2*ns2)**2*mt2*ac2
     /                         *Exp(L10*lkm2tet-zm2*pot1*pc)
      t1cs = (ft1*ns1)*zt1*faraday
      t1hcs = t1h*(zt1 + zh)*faraday
      t1m2cs = t1m2*(zt1)*faraday
      t1m2bcs = t1m2b*(zt1 + zt1)*faraday
      t1mcs = t1m*(zt1)*faraday
      t1acs = t1a*(zt1 + zh)*faraday
      t2cs = (ft2*ns2)*zt2*faraday
      t2hcs = t2h*(zt2 + zh)*faraday
      t2m2cs = t2m2*(zt2)*faraday
      t2m2bcs = t2m2b*(zt2 + zt2)*faraday
      t2mcs = t2m*(zt2)*faraday
      t2acs = t2a*(zt2 + zh)*faraday
      t1t2m2tetcs = t1t2m2tet*((zt1*2) + (zt2*2))*faraday
      suctcs = t1cs + t1hcs + t1m2cs + t1m2bcs + t1mcs 
     /   + t1acs + t2cs + t2hcs + t2m2cs + t2m2bcs + t2mcs
     /   + t2acs + t1t2m2tetcs
      sucte = (spt - pot1)*c1
      diffsuct = (suctcs - sucte)
C
*     FUNCTION diffl1
      mt2ads = t1m2 + t1m2b + t2m2 + t2m2b + t1t2m2tet
      totl1cs = (t1m2 + t1m2b + t2m2 + t2m2b
     /                         + t1t2m2tet)*(zm2*faraday)
      totl1ce = ((pot1 - pot2)*c2) + ((pot1 - spt)*c1)
      diffl1 = (totl1cs - totl1ce)
C
*     FUNCTION diffl2
      totl2cs = (t1m + t2m)*(zm*faraday)
      totl2ce = ((pot2 - pot3)*c3) + ((pot2 - pot1)*c2)
      diffl2 = (totl2cs - totl2ce)
C
*     FUNCTION diffl3
      totl3cs = (t1a + t2a)*(za*faraday)
      totl3ce = ((pot3 - potd)*cd) + ((pot3 - pot2)*c3)
      diffl3 = (totl3cs - totl3ce)
C
*     FUNCTION diffdl
      t1cd = (ft1*ns1)*zt1*faraday*-1
      t1hcd = t1h*(zt1 + zh)*faraday*-1
      t1m2cd = t1m2*(zt1 + zm2)*faraday*-1
      t1m2bcd = t1m2b*(zt1 + zt1 + zm2)*faraday*-1
      t1mcd = t1m*(zt1 + zm)*faraday*-1
      t1acd = t1a*(zt1 + za + zh)*faraday*-1
      t2cd = (ft2*ns2)*zt2*faraday*-1
      t2hcd = t2h*(zt2 + zh)*faraday*-1
      t2m2cd = t2m2*(zt2 + zm2)*faraday*-1
      t2m2bcd = t2m2b*(zt2 + zt2 + zm2)*faraday*-1
      t2mcd = t2m*(zt2 + zm)*faraday*-1
      t2acd = t2a*(zt2 + za + zh)*faraday*-1
      t1t2m2tetcd = t1t2m2tet*((zt1*2) + (zt2*2) + zm2)
     /              *faraday*(-1)
      totdlcsa = t1cd + t1hcd + t1m2cd + t1m2bcd + t1mcd 
     /     + t1acd + t2cd + t2hcd + t2m2cd + t2m2bcd + t2mcd
     /     + t2acd + t1t2m2tetcd
      totdlcs = (potd - pot3)*cd
      totdlce = -xt*Sinh((faraday*potd)/(2*rc*tempk))
      diffdl = (totdlcs - totdlce)
C
*     FUNCTION diffns1
      ns1b = (ft1*ns1) + t1h + t1m2 + (2*t1m2b) + (t1t2m2tet*2)
     / + t1m + t1a
      diffns1 = (ns1b - ns1)
C
*     FUNCTION diffns2
      ns2b = (ft2*ns2) + t2h + t2m2 + (2*t2m2b) + (t1t2m2tet*2)
     /         + t2m + t2a
      diffns2 = (ns2b - ns2)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of nonlinear
C     equations:
C
*     FUNCTION ft1_0
      ft1_0 = 1
C
*     FUNCTION ft2_0
      ft2_0 = 1
C
*     FUNCTION spt_0
      spt_0 = 0
C
*     FUNCTION pot1_0
      pot1_0 = 0
C
*     FUNCTION pot2_0
      pot2_0 = 0
C
*     FUNCTION pot3_0
      pot3_0 = 0
C
*     FUNCTION potd_0
      potd_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION sucte_fit
      sucte_fit = sucte
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

