C
C------------------------------------------------------
C
C     Problem:    4BAR_LNK
C
C     Date:       12.11.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      eps = 1E-5
      pi = 3.1415926535
      n = 24
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      p, h, q, s, i
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION phi
      theta = 2*pi*i/n
      pc = p*cos(theta)
      ps = p*sin(theta)
      phi = acos((q**2 + p**2 + 1 + 2*pc - h**2)
     /       /(2*q*sqrt(p**2 + 1 + 2*pc))) + atan(ps/(s + pc))
C
*     FUNCTION phi_sin
      theta = 2*pi*i/n
      beta = pi/4
      theta_max = 7*pi/9
      theta_min = pi/6
      phi_sin = 0.5*(theta_max + theta_min) 
     /     + 0.5*(theta_max - theta_min)*sin(theta-beta)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g1
      g1 = s - p - eps
C
*     FUNCTION g2
      g2 = q - p - eps
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C






