C
C------------------------------------------------------
C
C     Problem:    2STGCSTR
C
C     Date:       04.06.2002
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      u11, u12, u21, u22, tf, t1, t2, x1, x2, x3, x4, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      g1 = 1.5E+7*(0.5251 - x1)*exp(-10/(x2 + 0.6932))
     /        - 1.5E+10*(0.4748 + x1)*exp(-15/(x2 + 0.6932)) 
     /        - 1.428
      x1_t = tf*(-3*x1 + g1)
C
*     FUNCTION x2_t
      if (t.le.t1) then
        u1 = u11      
      else
        u1 = u12  
      endif
      x2_t = tf*(-11.1558*x2 + g1 - 8.1558*(x2 + 0.1592)*u1)
C
*     FUNCTION x3_t
      g2 = 1.5E+7*(0.4236 - x2)*exp(-10/(x4 + 0.656))
     /        - 1.5E+10*(0.5764 + x3)*exp(-15/(x4 + 0.656)) 
     /        - 0.5086
      x3_t = tf*(1.5*(0.5*x1 - x3) + g2)
C
*     FUNCTION x4_t
      if (t.le.t2) then
        u2 = u21
      else
        u2 = u22
      endif
      x4_t = tf*(0.75*x2 - 4.9385*x4 + g2 - 3.4385*(x4 + 0.122)*u2)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      if (t.lt.0.0001) then
        x1_0 = 0.1962
      else
        x1_0 = x1
      endif
C
*     FUNCTION x2_0
      if (t.lt.0.0001) then
        x2_0 = -0.0372
      else
        x2_0 = x2
      endif
C
*     FUNCTION x3_0
      if (t.lt.0.0001) then
        x3_0 = 0.0946
      else
        x3_0 = x3
      endif
C
*     FUNCTION x4_0
      if (t.lt.0.0001) then
        x4_0 = 0
      else
        x4_0 = x4
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
*     FUNCTION x4_fit
      x4_fit = x4
C
*     FUNCTION tf_fit
      tf_fit = 0.0001*tf
C
*     FUNCTION u1_ctrl
      if (t.le.t1) then
        u1 = u11
      else
        u1 = u12
      endif
      u1_ctrl = u1
C
*     FUNCTION u2_ctrl
      if (t.le.t2) then
        u2 = u21
      else
        u2 = u22
      endif
      u2_ctrl = u2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION c1
      c1 = t1 - t2 - 0.001
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

